/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.runtime.LeaseBase;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultDynamicCredentials;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.backend.VaultInternalSystemBackend;
import io.quarkus.vault.runtime.client.dto.dynamic.VaultDynamicCredentialsData;
import io.quarkus.vault.runtime.client.dto.sys.VaultRenewLease;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalDynamicCredentialsSecretEngine;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class VaultDynamicCredentialsManager {
    private static final Logger log = Logger.getLogger((String)VaultDynamicCredentialsManager.class.getName());
    private ConcurrentHashMap<String, VaultDynamicCredentials> credentialsCache = new ConcurrentHashMap();
    private VaultAuthManager vaultAuthManager;
    private VaultConfigHolder vaultConfigHolder;
    private VaultInternalSystemBackend vaultInternalSystemBackend;
    private VaultInternalDynamicCredentialsSecretEngine vaultInternalDynamicCredentialsSecretEngine;

    public VaultDynamicCredentialsManager(VaultConfigHolder vaultConfigHolder, VaultAuthManager vaultAuthManager, VaultInternalSystemBackend vaultInternalSystemBackend, VaultInternalDynamicCredentialsSecretEngine vaultInternalDynamicCredentialsSecretEngine) {
        this.vaultConfigHolder = vaultConfigHolder;
        this.vaultAuthManager = vaultAuthManager;
        this.vaultInternalSystemBackend = vaultInternalSystemBackend;
        this.vaultInternalDynamicCredentialsSecretEngine = vaultInternalDynamicCredentialsSecretEngine;
    }

    private String getCredentialsPath(String mount, String requestPath) {
        return mount + "/" + requestPath;
    }

    private String getCredentialsCacheKey(String mount, String requestPath, String role) {
        return this.getCredentialsPath(mount, requestPath) + "@" + role;
    }

    VaultDynamicCredentials getCachedCredentials(String mount, String requestPath, String role) {
        return this.credentialsCache.get(this.getCredentialsCacheKey(mount, requestPath, role));
    }

    void putCachedCredentials(String mount, String requestPath, String role, VaultDynamicCredentials credentials) {
        this.credentialsCache.put(this.getCredentialsCacheKey(mount, requestPath, role), credentials);
    }

    private VaultBootstrapConfig getConfig() {
        return this.vaultConfigHolder.getVaultBootstrapConfig();
    }

    public Map<String, String> getDynamicCredentials(String mount, String requestPath, String role) {
        String clientToken = this.vaultAuthManager.getClientToken();
        VaultDynamicCredentials currentCredentials = this.getCachedCredentials(mount, requestPath, role);
        VaultDynamicCredentials credentials = this.getCredentials(currentCredentials, clientToken, mount, requestPath, role);
        this.putCachedCredentials(mount, requestPath, role, credentials);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user", credentials.username);
        properties.put("password", credentials.password);
        properties.put("expires-at", credentials.getExpireInstant().toString());
        return properties;
    }

    public VaultDynamicCredentials getCredentials(VaultDynamicCredentials currentCredentials, String clientToken, String mount, String requestPath, String role) {
        VaultDynamicCredentials credentials = currentCredentials;
        if (credentials != null) {
            credentials = this.validate(credentials, clientToken);
        }
        if (credentials != null && credentials.shouldExtend(this.getConfig().renewGracePeriod)) {
            credentials = this.extend(credentials, clientToken, mount, requestPath, role);
        }
        if (credentials == null || credentials.isExpired() || credentials.expiresSoon(this.getConfig().renewGracePeriod)) {
            credentials = this.create(clientToken, mount, requestPath, role);
        }
        return credentials;
    }

    private VaultDynamicCredentials validate(VaultDynamicCredentials credentials, String clientToken) {
        try {
            this.vaultInternalSystemBackend.lookupLease(clientToken, credentials.leaseId);
            return credentials;
        }
        catch (VaultClientException e) {
            if (e.getStatus() == 400) {
                log.debug((Object)("lease " + credentials.leaseId + " has become invalid"));
                return null;
            }
            throw e;
        }
    }

    private VaultDynamicCredentials extend(VaultDynamicCredentials currentCredentials, String clientToken, String mount, String requestPath, String role) {
        VaultRenewLease vaultRenewLease = this.vaultInternalSystemBackend.renewLease(clientToken, currentCredentials.leaseId);
        LeaseBase lease = new LeaseBase(vaultRenewLease.leaseId, vaultRenewLease.renewable, vaultRenewLease.leaseDurationSecs);
        VaultDynamicCredentials credentials = new VaultDynamicCredentials(lease, currentCredentials.username, currentCredentials.password);
        this.sanityCheck(credentials, mount, requestPath, role);
        log.debug((Object)("extended " + role + "(" + this.getCredentialsPath(mount, requestPath) + ") credentials:" + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel)));
        return credentials;
    }

    private VaultDynamicCredentials create(String clientToken, String mount, String requestPath, String role) {
        io.quarkus.vault.runtime.client.dto.dynamic.VaultDynamicCredentials vaultDynamicCredentials = this.vaultInternalDynamicCredentialsSecretEngine.generateCredentials(clientToken, mount, requestPath, role);
        LeaseBase lease = new LeaseBase(vaultDynamicCredentials.leaseId, vaultDynamicCredentials.renewable, vaultDynamicCredentials.leaseDurationSecs);
        VaultDynamicCredentials credentials = new VaultDynamicCredentials(lease, ((VaultDynamicCredentialsData)vaultDynamicCredentials.data).username, ((VaultDynamicCredentialsData)vaultDynamicCredentials.data).password);
        log.debug((Object)("generated " + role + "(" + this.getCredentialsPath(mount, requestPath) + ") credentials:" + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel)));
        this.sanityCheck(credentials, mount, requestPath, role);
        return credentials;
    }

    private void sanityCheck(VaultDynamicCredentials credentials, String mount, String requestPath, String role) {
        credentials.leaseDurationSanityCheck(role + " (" + this.getCredentialsPath(mount, requestPath) + ")", this.getConfig().renewGracePeriod);
    }
}

