/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.pki;

import io.quarkus.vault.pki.DataFormat;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public interface PrivateKeyData {
    public DataFormat getFormat();

    public Object getData();

    public boolean isPKCS8();

    public KeySpec getKeySpec();

    public static class PEM
    implements PrivateKeyData {
        private final String pemData;
        private final boolean pkcs8;

        public PEM(String pemData, boolean pkcs8) {
            this.pemData = pemData;
            this.pkcs8 = pkcs8;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.PEM;
        }

        @Override
        public String getData() {
            return this.pemData;
        }

        @Override
        public boolean isPKCS8() {
            return this.pkcs8;
        }

        @Override
        public KeySpec getKeySpec() {
            if (!this.pkcs8) {
                throw new IllegalStateException("Key must be PKCS8 encoded");
            }
            String base64Data = this.pemData.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
            byte[] derData = Base64.getMimeDecoder().decode(base64Data);
            return new PKCS8EncodedKeySpec(derData);
        }
    }

    public static class DER
    implements PrivateKeyData {
        private final byte[] derData;
        private final boolean pkcs8;

        public DER(byte[] derData, boolean pkcs8) {
            this.derData = derData;
            this.pkcs8 = pkcs8;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.DER;
        }

        public byte[] getData() {
            return this.derData;
        }

        @Override
        public boolean isPKCS8() {
            return this.pkcs8;
        }

        @Override
        public KeySpec getKeySpec() {
            if (!this.pkcs8) {
                throw new IllegalStateException("Key must be PKCS8 encoded");
            }
            return new PKCS8EncodedKeySpec(this.derData);
        }
    }
}

