/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.backup.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.backup.ContainerResource;
import org.infinispan.server.core.backup.resources.AbstractContainerResource;
import org.infinispan.server.core.backup.resources.SecurityActions;
import org.infinispan.util.concurrent.BlockingManager;

class InternalCacheResource
extends AbstractContainerResource {
    private static final Map<BackupManager.Resources.Type, String> cacheMap = new HashMap<BackupManager.Resources.Type, String>(2);
    private final AdvancedCache<String, String> cache;

    private InternalCacheResource(BackupManager.Resources.Type type, AdvancedCache<String, String> cache, BlockingManager blockingManager, BackupManager.Resources params, Path root) {
        super(type, params, blockingManager, root);
        this.cache = cache;
    }

    static ContainerResource create(BackupManager.Resources.Type type, BlockingManager blockingManager, EmbeddedCacheManager cm, BackupManager.Resources params, Path root) {
        String cacheName = cacheMap.get((Object)type);
        if (SecurityActions.getCacheConfiguration(cm, cacheName) == null) {
            return null;
        }
        AdvancedCache cache = SecurityActions.getUnwrappedCache(cm.getCache(cacheName));
        return new InternalCacheResource(type, cache, blockingManager, params, root);
    }

    @Override
    public void prepareAndValidateBackup() {
        if (this.wildcard) {
            this.resources.addAll(this.cache.keySet());
            return;
        }
        for (String fileName : this.resources) {
            if (this.cache.containsKey((Object)fileName)) continue;
            throw log.unableToFindResource(this.type.toString(), fileName);
        }
    }

    @Override
    public CompletionStage<Void> backup() {
        return this.blockingManager.runBlocking(() -> {
            this.mkdirs(this.root);
            for (Map.Entry entry : this.cache.entrySet()) {
                String fileName = (String)entry.getKey();
                if (!this.resources.contains(fileName)) continue;
                Path file = this.root.resolve(fileName);
                try {
                    Files.write(file, ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new CacheException(String.format("Unable to create %s", file), (Throwable)e);
                }
                log.debugf("Backup up %s %s", (Object)this.type, fileName);
            }
        }, (Object)("write-" + this.type.toString()));
    }

    @Override
    public CompletionStage<Void> restore(ZipFile zip) {
        return this.blockingManager.runBlocking(() -> {
            for (String file : this.resources) {
                String zipPath = this.root.resolve(file).toString();
                try {
                    InputStream is = zip.getInputStream(zip.getEntry(zipPath));
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                        String content = reader.lines().collect(Collectors.joining("\n"));
                        this.cache.put((Object)file, (Object)content);
                        log.debugf("Restoring %s %s", (Object)this.type, file);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }, (Object)("restore-" + this.type.toString()));
    }

    static {
        cacheMap.put(BackupManager.Resources.Type.PROTO_SCHEMAS, "___protobuf_metadata");
        cacheMap.put(BackupManager.Resources.Type.TASKS, "___script_cache");
    }
}

