/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.change.AbstractTableChange;
import liquibase.change.ChangeStatus;
import liquibase.change.ChangeWithColumns;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.exception.DateParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.io.EmptyLineAndCommentSkippingInputStream;
import liquibase.logging.Logger;
import liquibase.repackaged.com.opencsv.exceptions.CsvMalformedLineException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.BatchDmlExecutablePreparedStatement;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.ExecutablePreparedStatementBase;
import liquibase.statement.InsertExecutablePreparedStatement;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Table;
import liquibase.util.BooleanUtil;
import liquibase.util.ObjectUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import liquibase.util.csv.CSVReader;

@DatabaseChange(name="loadData", description="Loads data from a CSV file into an existing table. A value of NULL in a cell will be converted to a database NULL rather than the string 'NULL'.\nLines starting with # (hash) sign are treated as comments. You can change comment pattern by specifying 'commentLineStartsWith' attribute.To disable comments set 'commentLineStartsWith' to empty value'\n\nIf the data type for a load column is set to NUMERIC, numbers are parsed in US locale (e.g. 123.45).\nDate/Time values included in the CSV file should be in ISO format http://en.wikipedia.org/wiki/ISO_8601 in order to be parsed correctly by Liquibase. Liquibase will initially set the date format to be 'yyyy-MM-dd'T'HH:mm:ss' and then it checks for two special cases which will override the data format string.\n\nIf the string representing the date/time includes a '.', then the date format is changed to 'yyyy-MM-dd'T'HH:mm:ss.SSS'\nIf the string representing the date/time includes a space, then the date format is changed to 'yyyy-MM-dd HH:mm:ss'\nOnce the date format string is set, Liquibase will then call the SimpleDateFormat.parse() method attempting to parse the input string so that it can return a Date/Time. If problems occur, then a ParseException is thrown and the input string is treated as a String for the INSERT command to be generated.\nIf UUID type is used UUID value is stored as string and NULL in cell is supported.", priority=1, appliesTo={"table"}, since="1.7")
public class LoadDataChange
extends AbstractTableChange
implements ChangeWithColumns<LoadDataColumnConfig> {
    public static final String DEFAULT_COMMENT_PATTERN = "#";
    public static final Pattern BASE64_PATTERN = Pattern.compile("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
    private static final Logger LOG = Scope.getCurrentScope().getLog(LoadDataChange.class);
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private String file;
    private String commentLineStartsWith = "#";
    private Boolean relativeToChangelogFile;
    private String encoding;
    private String separator = ",";
    private String quotchar = "\"";
    private List<LoadDataColumnConfig> columns = new ArrayList<LoadDataColumnConfig>();
    private Boolean usePreparedStatements;

    protected static String getValueToWrite(Object value) {
        if (value == null || "NULL".equalsIgnoreCase(value.toString())) {
            return "";
        }
        return value.toString().trim();
    }

    protected boolean hasPreparedStatementsImplemented() {
        return true;
    }

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        return true;
    }

    @Override
    @DatabaseChangeProperty(description="Name of the table to insert data into", requiredForDatabase={"all"}, mustEqualExisting="table")
    public String getTableName() {
        return super.getTableName();
    }

    @DatabaseChangeProperty(description="CSV file to load", exampleValue="com/example/users.csv", requiredForDatabase={"all"})
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @DatabaseChangeProperty(description="Use prepared statements instead of insert statement strings if the DB supports it")
    public Boolean getUsePreparedStatements() {
        return this.usePreparedStatements;
    }

    public void setUsePreparedStatements(Boolean usePreparedStatements) {
        this.usePreparedStatements = usePreparedStatements;
    }

    @DatabaseChangeProperty(supportsDatabase={"all"}, description="Lines staring with this are treated as comment and ignored. Default: #")
    public String getCommentLineStartsWith() {
        return this.commentLineStartsWith;
    }

    public void setCommentLineStartsWith(String commentLineStartsWith) {
        this.commentLineStartsWith = commentLineStartsWith == null ? DEFAULT_COMMENT_PATTERN : ("".equals(commentLineStartsWith) ? null : commentLineStartsWith);
    }

    @DatabaseChangeProperty(supportsDatabase={"all"}, description="Option whether the 'file' is relative to the changelog file")
    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    @DatabaseChangeProperty(exampleValue="UTF-8", supportsDatabase={"all"}, description="Encoding of the CSV file (defaults to UTF-8)")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @DatabaseChangeProperty(exampleValue=",", supportsDatabase={"all"}, description="Character separating the fields. Default: ,")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        if (separator != null && "\\t".equals(separator)) {
            separator = "\t";
        }
        this.separator = separator;
    }

    @DatabaseChangeProperty(exampleValue="'", supportsDatabase={"all"}, description="The quote character for string fields containing the separator character. Default: \"")
    public String getQuotchar() {
        return this.quotchar;
    }

    public void setQuotchar(String quotchar) {
        this.quotchar = quotchar;
    }

    @Override
    public void addColumn(LoadDataColumnConfig column) {
        this.columns.add(column);
    }

    @Override
    @DatabaseChangeProperty(supportsDatabase={"all"}, serializationType=LiquibaseSerializable.SerializationType.NESTED_OBJECT, description="Column mapping and defaults can be defined.\n\n'header' or 'index' attributes needs to be defined if the header name in the CSV is different than the column name needs to be inserted\nNot defined column type it is taken from the DB.\nThe 'defaultValue[XXX]' attributes can define value for empty fields.")
    public List<LoadDataColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<LoadDataColumnConfig> columns) {
        this.columns = columns;
    }

    protected String columnIdString(int index, LoadDataColumnConfig columnConfig) {
        return " / column[" + index + "]" + (StringUtil.trimToNull(columnConfig.getName()) != null ? " (name:'" + columnConfig.getName() + "')" : "");
    }

    protected ValidationErrors validateColumns(ValidationErrors validationErrors) {
        if (this.getColumns() != null) {
            int i2 = 1;
            for (LoadDataColumnConfig columnConfig : this.getColumns()) {
                this.validateColumn(columnConfig, validationErrors, this.columnIdString(i2, columnConfig));
                ++i2;
            }
        }
        return validationErrors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SqlStatement[] generateStatements(Database database) {
        boolean databaseSupportsBatchUpdates = false;
        try {
            if (!(database instanceof MySQLDatabase)) {
                databaseSupportsBatchUpdates = database.supportsBatchUpdates();
            }
        }
        catch (DatabaseException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
        CSVReader reader = null;
        try {
            reader = this.getCSVReader();
            if (reader == null) {
                throw new UnexpectedLiquibaseException("Unable to read file " + this.getFile());
            }
            String[] headers = reader.readNext();
            if (headers == null) {
                throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was empty");
            }
            this.addColumnsFromHeaders(headers);
            try {
                this.retrieveMissingColumnLoadTypes(this.columns, database);
            }
            catch (DatabaseException e3) {
                throw new UnexpectedLiquibaseException(e3);
            }
            ArrayList<ExecutablePreparedStatementBase> preparedStatements = new ArrayList<ExecutablePreparedStatementBase>();
            boolean anyPreparedStatements = false;
            int lineNumber = 1;
            boolean isCommentingEnabled = StringUtil.isNotEmpty(this.commentLineStartsWith);
            ArrayList<InsertStatement> statements = new ArrayList<InsertStatement>();
            while (true) {
                int n2;
                ArrayList columnsFromCsv;
                boolean needsPreparedStatement2;
                String[] line;
                if ((line = reader.readNext()) != null) {
                    ++lineNumber;
                    if (line.length == 0 || line.length == 1 && StringUtil.trimToNull(line[0]) == null || isCommentingEnabled && this.isLineCommented(line)) continue;
                    if (line.length != headers.length) {
                        throw new UnexpectedLiquibaseException("CSV file " + this.getFile() + " Line " + lineNumber + " has " + line.length + " values defined, Header has " + headers.length + ". Numbers MUST be equal (check for unquoted string with embedded commas)");
                    }
                    needsPreparedStatement2 = false;
                    columnsFromCsv = new ArrayList();
                } else {
                    if (anyPreparedStatements) {
                        if (databaseSupportsBatchUpdates && statements.isEmpty() && !preparedStatements.isEmpty()) {
                            if (database instanceof PostgresDatabase) {
                                SqlStatement[] needsPreparedStatement2 = preparedStatements.toArray(new SqlStatement[preparedStatements.size()]);
                                return needsPreparedStatement2;
                            }
                            SqlStatement[] needsPreparedStatement2 = new SqlStatement[]{new BatchDmlExecutablePreparedStatement(database, this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.columns, this.getChangeSet(), Scope.getCurrentScope().getResourceAccessor(), preparedStatements)};
                            return needsPreparedStatement2;
                        }
                        SqlStatement[] needsPreparedStatement2 = statements.toArray(new SqlStatement[statements.size()]);
                        return needsPreparedStatement2;
                    }
                    if (statements.isEmpty()) {
                        SqlStatement[] needsPreparedStatement2 = new SqlStatement[]{};
                        return needsPreparedStatement2;
                    }
                    InsertSetStatement statementSet = this.createStatementSet(this.getCatalogName(), this.getSchemaName(), this.getTableName());
                    for (SqlStatement sqlStatement : statements) {
                        statementSet.addInsertStatement((InsertStatement)sqlStatement);
                    }
                    if (database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof PostgresDatabase) {
                        List<InsertStatement> innerStatements = statementSet.getStatements();
                        if (innerStatements != null && !innerStatements.isEmpty() && innerStatements.get(0) instanceof InsertOrUpdateStatement) {
                            SqlStatement[] sqlStatementArray = statementSet.getStatementsArray();
                            return sqlStatementArray;
                        }
                        SqlStatement[] sqlStatementArray = new SqlStatement[]{statementSet};
                        return sqlStatementArray;
                    }
                    SqlStatement[] sqlStatementArray = statementSet.getStatementsArray();
                    return sqlStatementArray;
                }
                for (n2 = 0; n2 < headers.length; ++n2) {
                    LoadDataColumnConfig valueConfig;
                    block86: {
                        String columnName;
                        String value;
                        block87: {
                            LoadDataColumnConfig columnConfig;
                            block98: {
                                block97: {
                                    block96: {
                                        DatabaseFunction function;
                                        block95: {
                                            block94: {
                                                block93: {
                                                    block92: {
                                                        block91: {
                                                            block90: {
                                                                block89: {
                                                                    block88: {
                                                                        value = line[n2];
                                                                        columnName = headers[n2].trim();
                                                                        valueConfig = new LoadDataColumnConfig();
                                                                        columnConfig = this.getColumnConfig(n2, columnName);
                                                                        if (columnConfig == null) break block87;
                                                                        if ("skip".equalsIgnoreCase(columnConfig.getType())) continue;
                                                                        if (columnConfig.getName() != null) {
                                                                            columnName = columnConfig.getName();
                                                                        }
                                                                        if ("NULL".equalsIgnoreCase(value)) {
                                                                            valueConfig.setType(columnConfig.getType());
                                                                        }
                                                                        valueConfig.setName(columnName);
                                                                        valueConfig.setAllowUpdate(columnConfig.getAllowUpdate());
                                                                        if (value.isEmpty()) {
                                                                            value = columnConfig.getDefaultValue();
                                                                        }
                                                                        if (!StringUtil.equalsWordNull(value)) break block88;
                                                                        valueConfig.setValue(null);
                                                                        break block86;
                                                                    }
                                                                    if (columnConfig.getType() != null) break block89;
                                                                    valueConfig.setValue(value);
                                                                    break block86;
                                                                }
                                                                if (columnConfig.getTypeEnum() != LOAD_DATA_TYPE.UNKNOWN) break block90;
                                                                valueConfig.setValue(value);
                                                                break block86;
                                                            }
                                                            if (columnConfig.getTypeEnum() != LOAD_DATA_TYPE.BOOLEAN) break block91;
                                                            if (value == null) {
                                                                valueConfig.setValueBoolean(columnConfig.getDefaultValueBoolean());
                                                                break block86;
                                                            } else {
                                                                valueConfig.setValueBoolean(BooleanUtil.parseBoolean(value));
                                                            }
                                                            break block86;
                                                        }
                                                        if (columnConfig.getTypeEnum() != LOAD_DATA_TYPE.NUMERIC) break block92;
                                                        if (value != null) {
                                                            valueConfig.setValueNumeric(value);
                                                            break block86;
                                                        } else {
                                                            valueConfig.setValueNumeric(columnConfig.getDefaultValueNumeric());
                                                        }
                                                        break block86;
                                                    }
                                                    if (!columnConfig.getType().toLowerCase().contains("date") && !columnConfig.getType().toLowerCase().contains("time")) break block93;
                                                    if ("NULL".equalsIgnoreCase(value) || "".equals(value)) {
                                                        valueConfig.setValue(null);
                                                        break block86;
                                                    } else {
                                                        try {
                                                            valueConfig.setType(columnConfig.getType());
                                                            if (value != null) {
                                                                valueConfig.setValueDate(value);
                                                            }
                                                            valueConfig.setValueDate(columnConfig.getDefaultValueDate());
                                                        }
                                                        catch (DateParseException e4) {
                                                            throw new UnexpectedLiquibaseException(e4);
                                                        }
                                                    }
                                                }
                                                if (columnConfig.getTypeEnum() != LOAD_DATA_TYPE.STRING) break block94;
                                                valueConfig.setType(columnConfig.getType());
                                                valueConfig.setValue(value == null ? "" : value);
                                                break block86;
                                            }
                                            if (columnConfig.getTypeEnum() != LOAD_DATA_TYPE.COMPUTED) break block95;
                                            if (null != value) {
                                                function = new DatabaseFunction(value);
                                                valueConfig.setValueComputed(function);
                                                break block86;
                                            } else {
                                                valueConfig.setValueComputed(columnConfig.getDefaultValueComputed());
                                            }
                                            break block86;
                                        }
                                        if (columnConfig.getTypeEnum() != LOAD_DATA_TYPE.SEQUENCE) break block96;
                                        if (value == null) {
                                            throw new UnexpectedLiquibaseException("Must set a sequence name in the loadData column defaultValue attribute");
                                        }
                                        function = new SequenceNextValueFunction(this.getSchemaName(), value);
                                        valueConfig.setValueComputed(function);
                                        break block86;
                                    }
                                    if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.BLOB.toString())) break block97;
                                    if ("NULL".equalsIgnoreCase(value)) {
                                        valueConfig.setValue(null);
                                        break block86;
                                    } else if (BASE64_PATTERN.matcher(value).matches()) {
                                        valueConfig.setType(columnConfig.getType());
                                        valueConfig.setValue(value);
                                        needsPreparedStatement2 = true;
                                        break block86;
                                    } else {
                                        valueConfig.setValueBlobFile(value);
                                        needsPreparedStatement2 = true;
                                    }
                                    break block86;
                                }
                                if (columnConfig.getTypeEnum() != LOAD_DATA_TYPE.CLOB) break block98;
                                valueConfig.setValueClobFile(value);
                                needsPreparedStatement2 = true;
                                break block86;
                            }
                            if (columnConfig.getTypeEnum() == LOAD_DATA_TYPE.UUID) {
                                valueConfig.setType(columnConfig.getType());
                                if ("NULL".equalsIgnoreCase(value)) {
                                    valueConfig.setValue(null);
                                    break block86;
                                } else {
                                    valueConfig.setValue(value);
                                }
                                break block86;
                            } else {
                                if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.OTHER.toString())) {
                                    throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("loaddata.type.is.not.supported"), columnConfig.getType()));
                                }
                                valueConfig.setType(columnConfig.getType());
                                if ("NULL".equalsIgnoreCase(value)) {
                                    valueConfig.setValue(null);
                                    break block86;
                                } else {
                                    valueConfig.setValue(value);
                                }
                            }
                            break block86;
                        }
                        if (columnName.contains("(") || columnName.contains(")") && database instanceof AbstractJdbcDatabase) {
                            columnName = ((AbstractJdbcDatabase)database).quoteObject(columnName, Column.class);
                        }
                        valueConfig.setName(columnName);
                        valueConfig.setValue(LoadDataChange.getValueToWrite(value));
                    }
                    columnsFromCsv.add(valueConfig);
                }
                n2 = 0;
                if (this.hasPreparedStatementsImplemented()) {
                    if (this.usePreparedStatements != null) {
                        if (!this.usePreparedStatements.booleanValue() && needsPreparedStatement2) {
                            throw new UnexpectedLiquibaseException("loadData is requesting usePreparedStatements=false but prepared statements are required");
                        }
                        n2 = this.usePreparedStatements.booleanValue() ? 1 : 0;
                    } else {
                        int n3 = n2 = needsPreparedStatement2 || databaseSupportsBatchUpdates && !this.isLoggingExecutor(database) ? 1 : 0;
                    }
                }
                if (n2 != 0) {
                    anyPreparedStatements = true;
                    ExecutablePreparedStatementBase stmt = this.createPreparedStatement(database, this.getCatalogName(), this.getSchemaName(), this.getTableName(), columnsFromCsv, this.getChangeSet(), Scope.getCurrentScope().getResourceAccessor());
                    preparedStatements.add(stmt);
                    continue;
                }
                InsertStatement insertStatement = this.createStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
                Iterator iterator = columnsFromCsv.iterator();
                while (iterator.hasNext()) {
                    LoadDataColumnConfig column = (LoadDataColumnConfig)iterator.next();
                    String columnName = column.getName();
                    Object value = column.getValueObject();
                    if (value == null) {
                        value = "NULL";
                    }
                    insertStatement.addColumnValue(columnName, value);
                    if (!(insertStatement instanceof InsertOrUpdateStatement)) continue;
                    ((InsertOrUpdateStatement)insertStatement).setAllowColumnUpdate(columnName, column.getAllowUpdate() == null || column.getAllowUpdate() != false);
                }
                statements.add(insertStatement);
            }
        }
        catch (CsvMalformedLineException e5) {
            throw new RuntimeException("Error parsing " + this.getRelativeTo() + " on line " + e5.getLineNumber() + ": " + e5.getMessage());
        }
        catch (IOException | LiquibaseException e6) {
            throw new RuntimeException(e6);
        }
        catch (UnexpectedLiquibaseException ule) {
            if (this.getChangeSet() == null) throw ule;
            if (this.getChangeSet().getFailOnError() == null) throw ule;
            if (this.getChangeSet().getFailOnError() != false) throw ule;
            LOG.info("Change set " + this.getChangeSet().toString(false) + " failed, but failOnError was false.  Error: " + ule.getMessage());
            SqlStatement[] sqlStatementArray = new SqlStatement[]{};
            return sqlStatementArray;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean isLoggingExecutor(Database database) {
        ExecutorService executorService = Scope.getCurrentScope().getSingleton(ExecutorService.class);
        return executorService.executorExists("logging", database) && executorService.getExecutor("logging", database) instanceof LoggingExecutor;
    }

    private void retrieveMissingColumnLoadTypes(List<LoadDataColumnConfig> columns, Database database) throws DatabaseException {
        Table snapshotOfTable;
        if (columns.stream().noneMatch(c2 -> c2.getType() == null)) {
            return;
        }
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(this.getCatalogName(), this.getSchemaName());
        catalogAndSchema = catalogAndSchema.standardize(database);
        Table targetTable = new Table(catalogAndSchema.getCatalogName(), catalogAndSchema.getSchemaName(), database.correctObjectName(this.getTableName(), Table.class));
        try {
            snapshotOfTable = SnapshotGeneratorFactory.getInstance().createSnapshot(targetTable, database, new SnapshotControl(database, Table.class, Column.class));
        }
        catch (InvalidExampleException e2) {
            throw new DatabaseException(e2);
        }
        if (snapshotOfTable == null) {
            LOG.warning(String.format(coreBundle.getString("could.not.snapshot.table.to.get.the.missing.column.type.information"), database.escapeTableName(targetTable.getSchema().getCatalogName(), targetTable.getSchema().getName(), targetTable.getName())));
            return;
        }
        HashMap<String, Column> tableColumns = new HashMap<String, Column>();
        for (Column c3 : snapshotOfTable.getColumns()) {
            tableColumns.put(database.correctObjectName(c3.getName(), Column.class), c3);
        }
        HashMap<String, LoadDataColumnConfig> columnConfigs = new HashMap<String, LoadDataColumnConfig>();
        for (LoadDataColumnConfig loadDataColumnConfig : columns) {
            columnConfigs.put(database.correctObjectName(loadDataColumnConfig.getName(), Column.class), loadDataColumnConfig);
        }
        for (Map.Entry entry : columnConfigs.entrySet()) {
            if (((LoadDataColumnConfig)entry.getValue()).getType() != null) continue;
            LoadDataColumnConfig columnConfig = (LoadDataColumnConfig)entry.getValue();
            Column c5 = (Column)tableColumns.get(entry.getKey());
            if (null == c5) {
                LOG.severe(String.format(coreBundle.getString("unable.to.find.column.in.table"), columnConfig.getName(), snapshotOfTable));
                continue;
            }
            DataType dataType = c5.getType();
            if (dataType == null) {
                LOG.warning(String.format(coreBundle.getString("unable.to.find.load.data.type"), columnConfig.toString(), snapshotOfTable));
                columnConfig.setType(LOAD_DATA_TYPE.STRING);
                continue;
            }
            LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().fromDescription(dataType.toString(), database);
            if (liquibaseDataType != null) {
                columnConfig.setType(liquibaseDataType.getLoadTypeName());
                continue;
            }
            LOG.warning(String.format(coreBundle.getString("unable.to.convert.load.data.type"), columnConfig.toString(), snapshotOfTable, dataType));
        }
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors(this);
        validationErrors.addAll(super.validate(database));
        return this.validateColumns(validationErrors);
    }

    public void validateColumn(LoadDataColumnConfig columnConfig, ValidationErrors validationErrors, String columnIDString) {
        if (columnConfig.getHeader() != null && columnConfig.getIndex() != null) {
            validationErrors.addWarning("Since attribute 'header' is also defined, 'index' ignored for " + validationErrors.getChangeName() + columnIDString);
        }
    }

    protected LoadDataColumnConfig columnConfigFromName(String name, Integer idx) {
        for (LoadDataColumnConfig c2 : this.columns) {
            if (!name.equals(c2.getName()) && !name.equals(c2.getHeader()) && !idx.equals(c2.getIndex())) continue;
            return c2;
        }
        if (null == StringUtil.trimToNull(name)) {
            throw new UnexpectedLiquibaseException("Unreferenced unnamed column is not supported");
        }
        LoadDataColumnConfig cfg = new LoadDataColumnConfig();
        this.columns.add(cfg);
        cfg.setName(name);
        return cfg;
    }

    private void addColumnsFromHeaders(String[] headers) {
        int i2 = 0;
        for (String columnNameFromHeader : headers) {
            LoadDataColumnConfig loadDataColumnConfig = this.columnConfigFromName(columnNameFromHeader, i2);
            loadDataColumnConfig.setIndex(i2);
            loadDataColumnConfig.setHeader(columnNameFromHeader);
            ++i2;
        }
    }

    private boolean isLineCommented(String[] line) {
        return StringUtil.startsWith(line[0], this.commentLineStartsWith);
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return true;
    }

    public CSVReader getCSVReader() throws IOException, LiquibaseException {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        if (resourceAccessor == null) {
            throw new UnexpectedLiquibaseException("No file resourceAccessor specified for " + this.getFile());
        }
        String relativeTo = this.getRelativeTo();
        InputStream stream = resourceAccessor.openStream(relativeTo, this.file);
        if (stream == null) {
            return null;
        }
        Reader streamReader = StreamUtil.readStreamWithReader(stream, this.getEncoding());
        char quotchar = StringUtil.trimToEmpty(this.quotchar).isEmpty() ? (char)'\u0001' : this.quotchar.charAt(0);
        if (this.separator == null) {
            this.separator = ",";
        }
        return new CSVReader(streamReader, this.separator.charAt(0), quotchar);
    }

    protected String getRelativeTo() {
        String relativeTo = null;
        if (ObjectUtil.defaultIfNull(this.isRelativeToChangelogFile(), false).booleanValue()) {
            relativeTo = this.getChangeSet().getFilePath();
        }
        return relativeTo;
    }

    protected ExecutablePreparedStatementBase createPreparedStatement(Database database, String catalogName, String schemaName, String tableName, List<LoadDataColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        return new InsertExecutablePreparedStatement(database, catalogName, schemaName, tableName, columns, changeSet, resourceAccessor);
    }

    protected InsertStatement createStatement(String catalogName, String schemaName, String tableName) {
        return new InsertStatement(catalogName, schemaName, tableName);
    }

    protected InsertSetStatement createStatementSet(String catalogName, String schemaName, String tableName) {
        return new InsertSetStatement(catalogName, schemaName, tableName);
    }

    protected LoadDataColumnConfig getColumnConfig(int index, String header) {
        for (LoadDataColumnConfig config : this.columns) {
            if (config.getIndex() != null && config.getIndex().equals(index)) {
                return config;
            }
            if (config.getHeader() != null && config.getHeader().equalsIgnoreCase(header)) {
                return config;
            }
            if (config.getName() == null || !config.getName().equalsIgnoreCase(header)) continue;
            return config;
        }
        return null;
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        return new ChangeStatus().unknown("Cannot check loadData status");
    }

    @Override
    public String getConfirmationMessage() {
        return String.format(coreBundle.getString("loaddata.successful"), this.getFile(), this.getTableName());
    }

    @Override
    public CheckSum generateCheckSum() {
        InputStream stream = null;
        try {
            stream = Scope.getCurrentScope().getResourceAccessor().openStream(this.getRelativeTo(), this.file);
            if (stream == null) {
                throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("file.not.found"), this.file));
            }
            stream = new EmptyLineAndCommentSkippingInputStream(stream, this.commentLineStartsWith);
            CheckSum checkSum = CheckSum.compute(this.getTableName() + ":" + CheckSum.compute(stream, true));
            return checkSum;
        }
        catch (IOException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Warnings warn(Database database) {
        return null;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    public static enum LOAD_DATA_TYPE {
        BOOLEAN,
        NUMERIC,
        DATE,
        STRING,
        COMPUTED,
        SEQUENCE,
        BLOB,
        CLOB,
        SKIP,
        UUID,
        OTHER,
        UNKNOWN;

    }
}

