/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.theme.PropertiesUtil;
import org.keycloak.theme.ThemeResourceProvider;
import org.keycloak.theme.ThemeResourceProviderFactory;

public class ClasspathThemeResourceProviderFactory
implements ThemeResourceProviderFactory,
ThemeResourceProvider {
    public static final String THEME_RESOURCES_TEMPLATES = "theme-resources/templates/";
    public static final String THEME_RESOURCES_RESOURCES = "theme-resources/resources/";
    public static final String THEME_RESOURCES_MESSAGES = "theme-resources/messages/";
    private final String id;
    private final ClassLoader classLoader;

    public ClasspathThemeResourceProviderFactory() {
        this("classpath", Thread.currentThread().getContextClassLoader());
    }

    public ClasspathThemeResourceProviderFactory(String id, ClassLoader classLoader) {
        this.id = id;
        this.classLoader = classLoader;
    }

    public ThemeResourceProvider create(KeycloakSession session) {
        return this;
    }

    public URL getTemplate(String name) throws IOException {
        return this.classLoader.getResource(THEME_RESOURCES_TEMPLATES + name);
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        URL rootResourceURL = this.classLoader.getResource(THEME_RESOURCES_RESOURCES);
        if (rootResourceURL == null) {
            return null;
        }
        String rootPath = rootResourceURL.getPath();
        URL resourceURL = this.classLoader.getResource(THEME_RESOURCES_RESOURCES + path);
        if (resourceURL == null || !resourceURL.getPath().startsWith(rootPath)) {
            return null;
        }
        return resourceURL.openConnection().getInputStream();
    }

    public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
        Properties m = new Properties();
        InputStream in = this.classLoader.getResourceAsStream(THEME_RESOURCES_MESSAGES + baseBundlename + "_" + locale.toString() + ".properties");
        if (in != null) {
            Charset encoding = PropertiesUtil.detectEncoding(in);
            try (InputStreamReader reader = new InputStreamReader(this.classLoader.getResourceAsStream(THEME_RESOURCES_MESSAGES + baseBundlename + "_" + locale.toString() + ".properties"), encoding);){
                m.load(reader);
            }
        }
        return m;
    }

    public String getId() {
        return this.id;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

