/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

class CodeGenerateUtil {
    private static final Logger logger = Logger.getLogger(CodeGenerateUtil.class);
    private static final String ACTIVE_CODE = "active_code";
    private static final Map<Class<? extends CommonClientSessionModel>, Supplier<ClientSessionParser>> PARSERS = new HashMap<Class<? extends CommonClientSessionModel>, Supplier<ClientSessionParser>>();

    CodeGenerateUtil() {
    }

    static <CS extends CommonClientSessionModel> ClientSessionParser<CS> getParser(Class<CS> clientSessionClass) {
        for (Class<? extends CommonClientSessionModel> c : PARSERS.keySet()) {
            if (!c.isAssignableFrom(clientSessionClass)) continue;
            return PARSERS.get(c).get();
        }
        return null;
    }

    static {
        PARSERS.put(AuthenticationSessionModel.class, () -> new AuthenticationSessionModelParser());
    }

    private static class AuthenticationSessionModelParser
    implements ClientSessionParser<AuthenticationSessionModel> {
        private AuthenticationSessionModelParser() {
        }

        @Override
        public AuthenticationSessionModel parseSession(String code, String tabId, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event) {
            return new AuthenticationSessionManager(session).getCurrentAuthenticationSession(realm, client, tabId);
        }

        @Override
        public String retrieveCode(KeycloakSession session, AuthenticationSessionModel authSession) {
            String nextCode = authSession.getAuthNote(CodeGenerateUtil.ACTIVE_CODE);
            if (nextCode == null) {
                String actionId = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes());
                authSession.setAuthNote(CodeGenerateUtil.ACTIVE_CODE, actionId);
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
                    AuthenticationSessionModel authenticationSession;
                    RootAuthenticationSessionModel rootAuthenticationSession = currentSession.authenticationSessions().getRootAuthenticationSession(authSession.getRealm(), authSession.getParentSession().getId());
                    AuthenticationSessionModel authenticationSessionModel = authenticationSession = rootAuthenticationSession == null ? null : rootAuthenticationSession.getAuthenticationSession(authSession.getClient(), authSession.getTabId());
                    if (authenticationSession != null) {
                        authenticationSession.setAuthNote(CodeGenerateUtil.ACTIVE_CODE, actionId);
                    }
                });
                nextCode = actionId;
            } else {
                logger.debug((Object)"Code already generated for authentication session, using same code");
            }
            return nextCode;
        }

        @Override
        public void removeExpiredSession(KeycloakSession session, AuthenticationSessionModel clientSession) {
            new AuthenticationSessionManager(session).removeAuthenticationSession(clientSession.getRealm(), clientSession, true);
        }

        @Override
        public boolean verifyCode(KeycloakSession session, String code, AuthenticationSessionModel authSession) {
            String activeCode = authSession.getAuthNote(CodeGenerateUtil.ACTIVE_CODE);
            if (activeCode == null) {
                logger.debug((Object)"Active code not found in authentication session");
                return false;
            }
            authSession.removeAuthNote(CodeGenerateUtil.ACTIVE_CODE);
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), currentSession -> {
                AuthenticationSessionModel authenticationSession = currentSession.authenticationSessions().getRootAuthenticationSession(authSession.getRealm(), authSession.getParentSession().getId()).getAuthenticationSession(authSession.getClient(), authSession.getTabId());
                authenticationSession.removeAuthNote(CodeGenerateUtil.ACTIVE_CODE);
            });
            return MessageDigest.isEqual(code.getBytes(), activeCode.getBytes());
        }

        @Override
        public boolean isExpired(KeycloakSession session, String code, AuthenticationSessionModel clientSession) {
            return false;
        }

        @Override
        public int getTimestamp(AuthenticationSessionModel clientSession) {
            return clientSession.getParentSession().getTimestamp();
        }

        @Override
        public void setTimestamp(AuthenticationSessionModel clientSession, int timestamp) {
            clientSession.getParentSession().setTimestamp(timestamp);
        }

        @Override
        public String getClientNote(AuthenticationSessionModel clientSession, String noteKey) {
            return clientSession.getClientNote(noteKey);
        }
    }

    static interface ClientSessionParser<CS extends CommonClientSessionModel> {
        public CS parseSession(String var1, String var2, KeycloakSession var3, RealmModel var4, ClientModel var5, EventBuilder var6);

        public String retrieveCode(KeycloakSession var1, CS var2);

        public void removeExpiredSession(KeycloakSession var1, CS var2);

        public boolean verifyCode(KeycloakSession var1, String var2, CS var3);

        public boolean isExpired(KeycloakSession var1, String var2, CS var3);

        public int getTimestamp(CS var1);

        public void setTimestamp(CS var1, int var2);

        public String getClientNote(CS var1, String var2);
    }
}

