/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.ClaimsRepresentation;
import org.keycloak.util.JsonSerialization;

public class AcrUtils {
    private static final Logger LOGGER = Logger.getLogger(AcrUtils.class);

    public static List<String> getRequiredAcrValues(String claimsParam) {
        return AcrUtils.getAcrValues(claimsParam, null, false);
    }

    public static List<String> getAcrValues(String claimsParam, String acrValuesParam) {
        return AcrUtils.getAcrValues(claimsParam, acrValuesParam, true);
    }

    private static List<String> getAcrValues(String claimsParam, String acrValuesParam, boolean notEssential) {
        ArrayList<String> acrValues = new ArrayList<String>();
        if (acrValuesParam != null && notEssential) {
            acrValues.addAll(Arrays.asList(acrValuesParam.split(" ")));
        }
        if (claimsParam != null) {
            try {
                ClaimsRepresentation claims = (ClaimsRepresentation)JsonSerialization.readValue((String)claimsParam, ClaimsRepresentation.class);
                ClaimsRepresentation.ClaimValue acrClaim = claims.getClaimValue("acr", ClaimsRepresentation.ClaimContext.ID_TOKEN, String.class);
                if (acrClaim != null && (notEssential || acrClaim.isEssential()) && acrClaim.getValues() != null) {
                    acrValues.addAll(acrClaim.getValues());
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Invalid claims parameter", (Throwable)e);
            }
        }
        return acrValues;
    }

    public static Map<String, Integer> getAcrLoaMap(ClientModel client) {
        String map = client.getAttribute("acr.loa.map");
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonSerialization.readValue((String)map, (TypeReference)new TypeReference<Map<String, Integer>>(){});
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Invalid client configuration (ACR-LOA map)");
            return Collections.emptyMap();
        }
    }

    public static String mapLoaToAcr(int loa, Map<String, Integer> acrLoaMap, Collection<String> acrValues) {
        String acr = null;
        if (!acrLoaMap.isEmpty() && !acrValues.isEmpty()) {
            int maxLoa = 0;
            for (String acrValue : acrValues) {
                Integer mappedLoa = acrLoaMap.get(acrValue);
                if (mappedLoa == null) {
                    try {
                        mappedLoa = Integer.parseInt(acrValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (mappedLoa == null || mappedLoa <= maxLoa || loa < mappedLoa) continue;
                acr = acrValue;
                maxLoa = mappedLoa;
            }
        }
        return acr;
    }
}

