/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.HashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilderException;
import org.jboss.logging.Logger;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ConsoleVerifyEmail
implements RequiredActionProvider {
    public static final ConsoleVerifyEmail SINGLETON = new ConsoleVerifyEmail();
    private static final Logger logger = Logger.getLogger(ConsoleVerifyEmail.class);
    public static String EMAIL_CODE = "email_code";

    public void evaluateTriggers(RequiredActionContext context) {
        if (context.getRealm().isVerifyEmail() && !context.getUser().isEmailVerified()) {
            context.getUser().addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            logger.debug((Object)"User is required to verify email");
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (context.getUser().isEmailVerified()) {
            context.success();
            authSession.removeAuthNote("VERIFY_EMAIL_KEY");
            return;
        }
        String email = context.getUser().getEmail();
        if (Validation.isBlank(email)) {
            context.ignore();
            return;
        }
        Response challenge = this.sendVerifyEmail(context);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent().clone().event(EventType.VERIFY_EMAIL).detail("email", context.getUser().getEmail());
        String code = context.getAuthenticationSession().getAuthNote("VERIFY_EMAIL_CODE");
        if (code == null) {
            this.requiredActionChallenge(context);
            return;
        }
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String emailCode = (String)formData.getFirst((Object)EMAIL_CODE);
        if (!code.equals(emailCode)) {
            context.challenge(this.challenge(context).message("invalidCodeMessage", new String[0]));
            event.error("invalid_code");
            return;
        }
        event.success();
        context.success();
    }

    public void close() {
    }

    protected ConsoleDisplayMode challenge(RequiredActionContext context) {
        return ConsoleDisplayMode.challenge((RequiredActionContext)context).header().param(EMAIL_CODE).label("console-email-code").challenge();
    }

    private Response sendVerifyEmail(RequiredActionContext context) throws UriBuilderException, IllegalArgumentException {
        KeycloakSession session = context.getSession();
        UserModel user = context.getUser();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        EventBuilder event = context.getEvent().clone().event(EventType.SEND_VERIFY_EMAIL).detail("email", user.getEmail());
        String code = SecretGenerator.getInstance().randomString(8);
        authSession.setAuthNote("VERIFY_EMAIL_CODE", code);
        RealmModel realm = session.getContext().getRealm();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("code", code);
        try {
            ((EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class)).setAuthenticationSession(authSession).setRealm(realm).setUser(user).send("emailVerificationSubject", "email-verification-with-code.ftl", attributes);
            event.success();
        }
        catch (EmailException e) {
            logger.error((Object)"Failed to send verification email", (Throwable)e);
            event.error("email_send_failed");
        }
        return this.challenge(context).text(context.form().getMessage("console-verify-email", new String[]{user.getEmail()}));
    }
}

