/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticatorUtil {
    public static boolean isLevelOfAuthenticationForced(AuthenticationSessionModel authSession) {
        return Boolean.parseBoolean(authSession.getClientNote("force-level-of-authentication"));
    }

    public static int getRequestedLevelOfAuthentication(AuthenticationSessionModel authSession) {
        String requiredLoa = authSession.getClientNote("requested-level-of-authentication");
        return requiredLoa == null ? -1 : Integer.parseInt(requiredLoa);
    }

    public static int getCurrentLevelOfAuthentication(AuthenticationSessionModel authSession) {
        String authSessionLoaNote = authSession.getAuthNote("level-of-authentication");
        return authSessionLoaNote == null ? -1 : Integer.parseInt(authSessionLoaNote);
    }

    public static boolean isLevelOfAuthenticationSatisfied(AuthenticationSessionModel authSession) {
        return AuthenticatorUtil.getRequestedLevelOfAuthentication(authSession) <= AuthenticatorUtil.getCurrentLevelOfAuthentication(authSession);
    }

    public static int getCurrentLevelOfAuthentication(AuthenticatedClientSessionModel clientSession) {
        String clientSessionLoaNote = clientSession.getNote("level-of-authentication");
        return clientSessionLoaNote == null ? -1 : Integer.parseInt(clientSessionLoaNote);
    }
}

