/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import javax.inject.Singleton;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Readiness;

@Singleton
@Readiness
public class ShutdownReadinessCheck
implements HealthCheck {
    protected static final String GRACEFUL_SHUTDOWN = "Graceful Shutdown";
    private volatile boolean shuttingDown;

    public void shutdown() {
        this.shuttingDown = true;
    }

    public HealthCheckResponse call() {
        if (this.shuttingDown) {
            return HealthCheckResponse.down((String)GRACEFUL_SHUTDOWN);
        }
        return HealthCheckResponse.up((String)GRACEFUL_SHUTDOWN);
    }
}

