/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.time.Duration;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.Version;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class InfinispanContainer
extends GenericContainer<InfinispanContainer> {
    public static final String IMAGE_BASENAME = "quay.io/infinispan/server";
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "secret";

    public InfinispanContainer() {
        this("quay.io/infinispan/server:" + Version.getMajorMinor());
    }

    public InfinispanContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
        this.withUser(DEFAULT_USERNAME);
        this.withPassword(DEFAULT_PASSWORD);
    }

    public InfinispanContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.logger().info("Starting an Infinispan container using [{}]", (Object)dockerImageName);
        this.withNetworkAliases(new String[]{"infinispan-" + Base58.randomString((int)6)});
        this.addExposedPorts(new int[]{11222, 7800});
        this.setWaitStrategy(new HttpWaitStrategy().forPort(11222).forStatusCodeMatching(response -> response == 200 || response == 401).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    public InfinispanContainer withUser(String user) {
        this.withEnv("USER", user);
        return this;
    }

    public InfinispanContainer withPassword(String password) {
        this.withEnv("PASS", password);
        return this;
    }

    public InfinispanContainer withArtifacts(String ... artifacts) {
        if (artifacts != null || artifacts.length > 0) {
            this.withEnv("SERVER_LIBS", String.join((CharSequence)" ", artifacts));
        }
        return this;
    }

    public RemoteCacheManager getRemoteCacheManager() {
        return this.getRemoteCacheManager(new ConfigurationBuilder());
    }

    public RemoteCacheManager getRemoteCacheManager(ConfigurationBuilder builder) {
        builder.addServer().host(this.getHost()).port(this.getMappedPort(11222).intValue()).security().authentication().username((String)this.getEnvMap().get("USER")).password((String)this.getEnvMap().get("PASS"));
        return new RemoteCacheManager(builder.build());
    }
}

