/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.util;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.keycloak.common.util.Base64;
import org.keycloak.dom.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.SignatureType;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.SecurityActions;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.common.util.SystemPropertiesUtil;
import org.keycloak.saml.common.util.TransformerUtil;
import org.keycloak.saml.processing.api.util.KeyInfoTools;
import org.keycloak.saml.processing.core.util.ProvidersUtil;
import org.keycloak.saml.processing.core.util.SignatureUtilTransferObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSignatureUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final XMLSignatureFactory fac;
    private static boolean includeKeyInfoInSignature;

    private static XMLSignatureFactory getXMLSignatureFactory() {
        XMLSignatureFactory xsf = null;
        try {
            xsf = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        }
        catch (NoSuchProviderException ex) {
            try {
                xsf = XMLSignatureFactory.getInstance("DOM");
            }
            catch (Exception err) {
                throw new RuntimeException((Throwable)logger.couldNotCreateInstance("DOM", err));
            }
        }
        return xsf;
    }

    public static void setIncludeKeyInfoInSignature(boolean includeKeyInfoInSignature) {
        XMLSignatureUtil.includeKeyInfoInSignature = includeKeyInfoInSignature;
    }

    public static Document sign(Document doc, Node nodeToBeSigned, String keyName, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, X509Certificate x509Certificate, String canonicalizationMethodType) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        if (nodeToBeSigned == null) {
            throw logger.nullArgumentError("Node to be signed");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Document to be signed=" + DocumentUtil.asString(doc));
        }
        Node parentNode = nodeToBeSigned.getParentNode();
        Document newDoc = DocumentUtil.createDocument();
        Node signingNode = newDoc.importNode(nodeToBeSigned, true);
        newDoc.appendChild(signingNode);
        if (!referenceURI.isEmpty()) {
            XMLSignatureUtil.propagateIDAttributeSetup(nodeToBeSigned, newDoc.getDocumentElement());
        }
        newDoc = XMLSignatureUtil.sign(newDoc, keyName, keyPair, digestMethod, signatureMethod, referenceURI, x509Certificate, canonicalizationMethodType);
        if (nodeToBeSigned.getLocalName().equals("Assertion") && "urn:oasis:names:tc:SAML:2.0:assertion".equals(nodeToBeSigned.getNamespaceURI())) {
            Element signatureNode = DocumentUtil.getElement(newDoc, new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"));
            Element subjectNode = DocumentUtil.getElement(newDoc, new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Subject"));
            if (signatureNode != null && subjectNode != null) {
                newDoc.getDocumentElement().removeChild(signatureNode);
                newDoc.getDocumentElement().insertBefore(signatureNode, subjectNode);
            }
        }
        Node signedNode = doc.importNode(newDoc.getFirstChild(), true);
        if (!referenceURI.isEmpty()) {
            XMLSignatureUtil.propagateIDAttributeSetup(newDoc.getDocumentElement(), (Element)signedNode);
        }
        parentNode.replaceChild(signedNode, nodeToBeSigned);
        return doc;
    }

    public static void sign(Element elementToSign, Node nextSibling, String keyName, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, String canonicalizationMethodType) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        XMLSignatureUtil.sign(elementToSign, nextSibling, keyName, keyPair, digestMethod, signatureMethod, referenceURI, null, canonicalizationMethodType);
    }

    public static void sign(Element elementToSign, Node nextSibling, String keyName, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, X509Certificate x509Certificate, String canonicalizationMethodType) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        PrivateKey signingKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)elementToSign, nextSibling);
        XMLSignatureUtil.signImpl(dsc, digestMethod, signatureMethod, referenceURI, keyName, publicKey, x509Certificate, canonicalizationMethodType);
    }

    public static void propagateIDAttributeSetup(Node sourceNode, Element destElement) {
        NamedNodeMap nnm = sourceNode.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr = (Attr)nnm.item(i);
            if (!attr.isId()) continue;
            destElement.setIdAttribute(attr.getName(), true);
            break;
        }
    }

    public static Document sign(Document doc, String keyName, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, String canonicalizationMethodType) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        return XMLSignatureUtil.sign(doc, keyName, keyPair, digestMethod, signatureMethod, referenceURI, null, canonicalizationMethodType);
    }

    public static Document sign(Document doc, String keyName, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI, X509Certificate x509Certificate, String canonicalizationMethodType) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        if (logger.isTraceEnabled()) {
            logger.trace("Document to be signed=" + DocumentUtil.asString(doc));
        }
        PrivateKey signingKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)doc.getDocumentElement());
        XMLSignatureUtil.signImpl(dsc, digestMethod, signatureMethod, referenceURI, keyName, publicKey, x509Certificate, canonicalizationMethodType);
        return doc;
    }

    public static Document sign(SignatureUtilTransferObject dto, String canonicalizationMethodType) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        Document doc = dto.getDocumentToBeSigned();
        String keyName = dto.getKeyName();
        KeyPair keyPair = dto.getKeyPair();
        Node nextSibling = dto.getNextSibling();
        String digestMethod = dto.getDigestMethod();
        String referenceURI = dto.getReferenceURI();
        String signatureMethod = dto.getSignatureMethod();
        if (logger.isTraceEnabled()) {
            logger.trace("Document to be signed=" + DocumentUtil.asString(doc));
        }
        PrivateKey signingKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)doc.getDocumentElement(), nextSibling);
        XMLSignatureUtil.signImpl(dsc, digestMethod, signatureMethod, referenceURI, keyName, publicKey, dto.getX509Certificate(), canonicalizationMethodType);
        if (logger.isTraceEnabled()) {
            logger.trace("Signed document=" + DocumentUtil.asString(doc));
        }
        return doc;
    }

    public static boolean validate(Document signedDoc, KeyLocator locator) throws MarshalException, XMLSignatureException {
        if (signedDoc == null) {
            throw logger.nullArgumentError("Signed Document");
        }
        XMLSignatureUtil.propagateIDAttributeSetup(signedDoc.getDocumentElement(), signedDoc.getDocumentElement());
        NodeList nl = signedDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl == null || nl.getLength() == 0) {
            logger.debug("Cannot find Signature element");
            return false;
        }
        if (locator == null) {
            throw logger.nullValueError("Public Key");
        }
        int signedAssertions = 0;
        String assertionNameSpaceUri = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node signatureNode = nl.item(i);
            Node parent = signatureNode.getParentNode();
            if (parent != null && JBossSAMLConstants.ASSERTION.get().equals(parent.getLocalName())) {
                ++signedAssertions;
                if (assertionNameSpaceUri == null) {
                    assertionNameSpaceUri = parent.getNamespaceURI();
                }
            }
            if (XMLSignatureUtil.validateSingleNode(signatureNode, locator)) continue;
            return false;
        }
        NodeList assertions = signedDoc.getElementsByTagNameNS(assertionNameSpaceUri, JBossSAMLConstants.ASSERTION.get());
        if (signedAssertions > 0 && assertions != null && assertions.getLength() != signedAssertions) {
            if (logger.isDebugEnabled()) {
                logger.debug("SAML Response document may contain malicious assertions. Signature validation will fail.");
            }
            return false;
        }
        return true;
    }

    public static boolean validateSingleNode(Node signatureNode, KeyLocator locator) throws MarshalException, XMLSignatureException {
        KeySelectorUtilizingKeyNameHint sel = new KeySelectorUtilizingKeyNameHint(locator);
        try {
            if (XMLSignatureUtil.validateUsingKeySelector(signatureNode, sel)) {
                return true;
            }
            if (sel.wasKeyLocated()) {
                return false;
            }
        }
        catch (XMLSignatureException ex) {
            logger.debug("Verification failed for key " + sel.keyName + ": " + ex);
            logger.trace(ex);
        }
        logger.trace("Could not validate signature using ds:KeyInfo/ds:KeyName hint.");
        if (locator instanceof Iterable) {
            Iterable availableKeys = (Iterable)((Object)locator);
            logger.trace("Trying hard to validate XML signature using all available keys.");
            for (Key key : availableKeys) {
                try {
                    if (!XMLSignatureUtil.validateUsingKeySelector(signatureNode, new KeySelectorPresetKey(key))) continue;
                    return true;
                }
                catch (XMLSignatureException ex) {
                    logger.debug("Verification failed: " + ex);
                    logger.trace(ex);
                }
            }
        }
        return false;
    }

    private static boolean validateUsingKeySelector(Node signatureNode, KeySelector validationKeySelector) throws XMLSignatureException, MarshalException {
        DOMValidateContext valContext = new DOMValidateContext(validationKeySelector, signatureNode);
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity && logger.isTraceEnabled()) {
            boolean sv = signature.getSignatureValue().validate(valContext);
            logger.trace("Signature validation status: " + sv);
            List<Reference> references = signature.getSignedInfo().getReferences();
            for (Reference ref : references) {
                logger.trace("[Ref id=" + ref.getId() + ":uri=" + ref.getURI() + "]validity status:" + ref.validate(valContext));
            }
        }
        return coreValidity;
    }

    public static void marshall(SignatureType signature, OutputStream os) throws JAXBException, SAXException {
        throw logger.notImplementedYet("NYI");
    }

    public static void marshall(Document signedDocument, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerUtil.getTransformerFactory();
        Transformer trans = tf.newTransformer();
        trans.transform(DocumentUtil.getXMLSource(signedDocument), new StreamResult(os));
    }

    public static X509Certificate getX509CertificateFromKeyInfoString(String certificateString) throws ProcessingException {
        X509Certificate cert = null;
        StringBuilder builder = new StringBuilder();
        builder.append("-----BEGIN CERTIFICATE-----\n").append(certificateString).append("\n-----END CERTIFICATE-----");
        String derFormattedString = builder.toString();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(derFormattedString.getBytes(GeneralConstants.SAML_CHARSET));
            while (bais.available() > 0) {
                cert = (X509Certificate)cf.generateCertificate(bais);
            }
        }
        catch (CertificateException e) {
            throw logger.processingError(e);
        }
        return cert;
    }

    public static DSAKeyValueType getDSAKeyValue(Element element) throws ParsingException {
        DSAKeyValueType dsa = new DSAKeyValueType();
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String tag = childElement.getLocalName();
            byte[] text = childElement.getTextContent().getBytes(GeneralConstants.SAML_CHARSET);
            if ("P".equals(tag)) {
                dsa.setP(text);
                continue;
            }
            if ("Q".equals(tag)) {
                dsa.setQ(text);
                continue;
            }
            if ("G".equals(tag)) {
                dsa.setG(text);
                continue;
            }
            if ("Y".equals(tag)) {
                dsa.setY(text);
                continue;
            }
            if ("Seed".equals(tag)) {
                dsa.setSeed(text);
                continue;
            }
            if (!"PgenCounter".equals(tag)) continue;
            dsa.setPgenCounter(text);
        }
        return dsa;
    }

    public static RSAKeyValueType getRSAKeyValue(Element element) throws ParsingException {
        RSAKeyValueType rsa = new RSAKeyValueType();
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String tag = childElement.getLocalName();
            byte[] text = childElement.getTextContent().getBytes(GeneralConstants.SAML_CHARSET);
            if ("Modulus".equals(tag)) {
                rsa.setModulus(text);
                continue;
            }
            if (!"Exponent".equals(tag)) continue;
            rsa.setExponent(text);
        }
        return rsa;
    }

    public static KeyValueType createKeyValue(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey pubKey = (RSAPublicKey)key;
            byte[] modulus = pubKey.getModulus().toByteArray();
            byte[] exponent = pubKey.getPublicExponent().toByteArray();
            RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
            rsaKeyValue.setModulus(Base64.encodeBytes((byte[])modulus).getBytes(GeneralConstants.SAML_CHARSET));
            rsaKeyValue.setExponent(Base64.encodeBytes((byte[])exponent).getBytes(GeneralConstants.SAML_CHARSET));
            return rsaKeyValue;
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey pubKey = (DSAPublicKey)key;
            byte[] P = pubKey.getParams().getP().toByteArray();
            byte[] Q = pubKey.getParams().getQ().toByteArray();
            byte[] G = pubKey.getParams().getG().toByteArray();
            byte[] Y = pubKey.getY().toByteArray();
            DSAKeyValueType dsaKeyValue = new DSAKeyValueType();
            dsaKeyValue.setP(Base64.encodeBytes((byte[])P).getBytes(GeneralConstants.SAML_CHARSET));
            dsaKeyValue.setQ(Base64.encodeBytes((byte[])Q).getBytes(GeneralConstants.SAML_CHARSET));
            dsaKeyValue.setG(Base64.encodeBytes((byte[])G).getBytes(GeneralConstants.SAML_CHARSET));
            dsaKeyValue.setY(Base64.encodeBytes((byte[])Y).getBytes(GeneralConstants.SAML_CHARSET));
            return dsaKeyValue;
        }
        throw logger.unsupportedType(key.toString());
    }

    private static void signImpl(DOMSignContext dsc, String digestMethod, String signatureMethod, String referenceURI, String keyName, PublicKey publicKey, X509Certificate x509Certificate, String canonicalizationMethodType) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        dsc.setDefaultNamespacePrefix("dsig");
        DigestMethod digestMethodObj = fac.newDigestMethod(digestMethod, null);
        Transform transform1 = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        Transform transform2 = fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        transformList.add(transform1);
        transformList.add(transform2);
        Reference ref = fac.newReference(referenceURI, digestMethodObj, transformList, null, null);
        CanonicalizationMethod canonicalizationMethod = fac.newCanonicalizationMethod(canonicalizationMethodType, (C14NMethodParameterSpec)null);
        List<Reference> referenceList = Collections.singletonList(ref);
        SignatureMethod signatureMethodObj = fac.newSignatureMethod(signatureMethod, null);
        SignedInfo si = fac.newSignedInfo(canonicalizationMethod, signatureMethodObj, referenceList);
        KeyInfo ki = includeKeyInfoInSignature ? XMLSignatureUtil.createKeyInfo(keyName, publicKey, x509Certificate) : XMLSignatureUtil.createKeyInfo(keyName, null, null);
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
    }

    private static KeyInfo createKeyInfo(String keyName, PublicKey publicKey, X509Certificate x509Certificate) throws KeyException {
        KeyInfoFactory keyInfoFactory = fac.getKeyInfoFactory();
        LinkedList<XMLStructure> items = new LinkedList<XMLStructure>();
        if (keyName != null) {
            items.add(keyInfoFactory.newKeyName(keyName));
        }
        if (x509Certificate != null) {
            items.add(keyInfoFactory.newX509Data(Collections.singletonList(x509Certificate)));
        }
        if (publicKey != null) {
            items.add(keyInfoFactory.newKeyValue(publicKey));
        }
        return keyInfoFactory.newKeyInfo(items);
    }

    static {
        ProvidersUtil.ensure();
        SystemPropertiesUtil.ensure();
        String keyInfoProp = SecurityActions.getSystemProperty("picketlink.xmlsig.includeKeyInfo", null);
        if (StringUtil.isNotNull(keyInfoProp)) {
            includeKeyInfoInSignature = Boolean.parseBoolean(keyInfoProp);
        }
        fac = XMLSignatureUtil.getXMLSignatureFactory();
        includeKeyInfoInSignature = true;
    }

    private static class KeySelectorPresetKey
    extends KeySelector {
        private final Key key;

        public KeySelectorPresetKey(Key key) {
            this.key = key;
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) {
            return new KeySelectorResult(){

                @Override
                public Key getKey() {
                    return KeySelectorPresetKey.this.key;
                }
            };
        }
    }

    private static class KeySelectorUtilizingKeyNameHint
    extends KeySelector {
        private final KeyLocator locator;
        private boolean keyLocated = false;
        private String keyName = null;

        public KeySelectorUtilizingKeyNameHint(KeyLocator locator) {
            this.locator = locator;
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            try {
                KeyName keyNameEl = KeyInfoTools.getKeyName(keyInfo);
                this.keyName = keyNameEl == null ? null : keyNameEl.getName();
                final Key key = this.locator.getKey(this.keyName);
                this.keyLocated = key != null;
                return new KeySelectorResult(){

                    @Override
                    public Key getKey() {
                        return key;
                    }
                };
            }
            catch (KeyManagementException ex) {
                throw new KeySelectorException(ex);
            }
        }

        private boolean wasKeyLocated() {
            return this.keyLocated;
        }
    }
}

