/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.ConfigHandler;
import org.keycloak.client.registration.cli.config.ConfigUpdateOperation;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.util.JsonSerialization;

public class FileConfigHandler
implements ConfigHandler {
    private static final long MAX_SIZE = 0xA00000L;
    private static String configFile;

    public static void setConfigFile(String filename) {
        configFile = filename;
    }

    public static String getConfigFile() {
        return configFile;
    }

    @Override
    public ConfigData loadConfig() {
        ConfigData configData;
        File file = new File(configFile);
        if (!file.isFile() || file.length() == 0L) {
            return new ConfigData();
        }
        FileInputStream is = new FileInputStream(configFile);
        try {
            configData = JsonSerialization.readValue((InputStream)is, ConfigData.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load " + configFile, e);
            }
        }
        is.close();
        return configData;
    }

    public static void ensureFile() {
        Path path = null;
        try {
            path = Paths.get(new File(configFile).getAbsolutePath(), new String[0]);
            IoUtil.ensureFile(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create config file: " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMergeConfig(ConfigUpdateOperation op) {
        block19: {
            try {
                FileConfigHandler.ensureFile();
                try (RandomAccessFile file = new RandomAccessFile(new File(configFile), "rw");){
                    FileChannel fileChannel = file.getChannel();
                    FileLock fileLock = null;
                    int tryCount = 0;
                    while (true) {
                        try {
                            fileLock = fileChannel.tryLock();
                        }
                        catch (OverlappingFileLockException e) {
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException e1) {
                                throw new RuntimeException("Interrupted");
                            }
                            if (tryCount++ < 10) continue;
                        }
                        break;
                    }
                    if (fileLock != null) {
                        try {
                            ConfigData config = new ConfigData();
                            long size = file.length();
                            if (size > 0xA00000L) {
                                IoUtil.printErr("Config file " + configFile + " is too big. It will be overwritten.");
                                file.setLength(0L);
                            } else if (size > 0L) {
                                byte[] buf = new byte[(int)size];
                                file.readFully(buf);
                                config = JsonSerialization.readValue((InputStream)new ByteArrayInputStream(buf), ConfigData.class);
                            }
                            op.update(config);
                            byte[] content = JsonSerialization.writeValueAsPrettyString(config).getBytes("utf-8");
                            file.seek(0L);
                            file.write(content);
                            file.setLength(content.length);
                            break block19;
                        }
                        finally {
                            fileLock.release();
                        }
                    }
                    throw new RuntimeException("Failed to get lock on " + configFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save " + configFile, e);
            }
        }
    }
}

