/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.util.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jxmpp.util.cache.Cache;

public class LruCache<K, V>
extends LinkedHashMap<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = -4980809402073634607L;
    private static final int DEFAULT_INITIAL_SIZE = 50;
    private int maxCacheSize;
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();

    public LruCache(int maxSize) {
        super(maxSize < 50 ? maxSize : 50, 0.75f, true);
        if (maxSize == 0) {
            throw new IllegalArgumentException("Max cache size cannot be 0.");
        }
        this.maxCacheSize = maxSize;
    }

    @Override
    protected final boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCacheSize;
    }

    @Override
    public final synchronized V put(K key, V value) {
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(Object key) {
        Object cacheObject;
        LruCache lruCache = this;
        synchronized (lruCache) {
            cacheObject = super.get(key);
        }
        if (cacheObject == null) {
            this.cacheMisses.incrementAndGet();
            return null;
        }
        this.cacheHits.incrementAndGet();
        return cacheObject;
    }

    @Override
    public final synchronized V remove(Object key) {
        return super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        LruCache lruCache = this;
        synchronized (lruCache) {
            super.clear();
        }
        this.cacheHits.set(0L);
        this.cacheMisses.set(0L);
    }

    @Override
    public final synchronized int size() {
        return super.size();
    }

    @Override
    public final synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public final synchronized Collection<V> values() {
        return super.values();
    }

    @Override
    public final synchronized boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public final synchronized void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
    }

    @Override
    public final synchronized boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public final synchronized Set<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    public final synchronized Set<K> keySet() {
        return super.keySet();
    }

    public final long getCacheHits() {
        return this.cacheHits.longValue();
    }

    public final long getCacheMisses() {
        return this.cacheMisses.longValue();
    }

    @Override
    public final int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public final void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }
}

