/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.simpleequals;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JOp;
import java.util.Arrays;
import org.jvnet.jaxb2_commons.plugin.codegenerator.AbstractCodeGenerationImplementor;
import org.jvnet.jaxb2_commons.plugin.simpleequals.EqualsArguments;

public class EqualsCodeGenerationImplementor
extends AbstractCodeGenerationImplementor<EqualsArguments> {
    public EqualsCodeGenerationImplementor(JCodeModel codeModel) {
        super(codeModel);
    }

    private void returnFalseIfNotEqualsCondition(EqualsArguments arguments, JBlock block, boolean isAlwaysSet, JExpression notEqualsCondition) {
        arguments.ifHasSetValue(block, isAlwaysSet, true)._if(notEqualsCondition)._then()._return(JExpr.FALSE);
    }

    private void returnFalseIfNe(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNotEqualsCondition(arguments, block, isAlwaysSet, JOp.ne((JExpression)arguments.leftValue(), (JExpression)arguments.rightValue()));
    }

    @Override
    public void onArray(JBlock block, boolean isAlwaysSet, EqualsArguments arguments) {
        this.returnFalseIfNotEqualsCondition(arguments, block, isAlwaysSet, this.getCodeModel().ref(Arrays.class).staticInvoke("equals").arg((JExpression)arguments.leftValue()).arg((JExpression)arguments.rightValue()).not());
    }

    @Override
    public void onBoolean(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNe(arguments, block, isAlwaysSet);
    }

    @Override
    public void onByte(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNe(arguments, block, isAlwaysSet);
    }

    @Override
    public void onChar(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNe(arguments, block, isAlwaysSet);
    }

    @Override
    public void onDouble(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        JClass Double$class = this.getCodeModel().ref(Double.class);
        JInvocation leftValueLongBits = Double$class.staticInvoke("doubleToLongBits").arg((JExpression)arguments.leftValue());
        JInvocation rightValueLongBits = Double$class.staticInvoke("doubleToLongBits").arg((JExpression)arguments.rightValue());
        this.returnFalseIfNotEqualsCondition(arguments, block, isAlwaysSet, JOp.ne((JExpression)leftValueLongBits, (JExpression)rightValueLongBits));
    }

    @Override
    public void onFloat(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        JClass Float$class = this.getCodeModel().ref(Float.class);
        JInvocation leftValueLongBits = Float$class.staticInvoke("floatToIntBits").arg((JExpression)arguments.leftValue());
        JInvocation rightValueLongBits = Float$class.staticInvoke("floatToIntBits").arg((JExpression)arguments.rightValue());
        this.returnFalseIfNotEqualsCondition(arguments, block, isAlwaysSet, JOp.ne((JExpression)leftValueLongBits, (JExpression)rightValueLongBits));
    }

    @Override
    public void onInt(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNe(arguments, block, isAlwaysSet);
    }

    @Override
    public void onLong(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNe(arguments, block, isAlwaysSet);
    }

    @Override
    public void onShort(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNe(arguments, block, isAlwaysSet);
    }

    @Override
    public void onObject(EqualsArguments arguments, JBlock block, boolean isAlwaysSet) {
        this.returnFalseIfNotEqualsCondition(arguments, block, isAlwaysSet, arguments.leftValue().invoke("equals").arg((JExpression)arguments.rightValue()).not());
    }
}

