/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mjiip.v_2_2;

import com.sun.tools.xjc.ErrorReceiver;
import org.apache.maven.plugin.logging.Log;
import org.xml.sax.SAXParseException;

public class LoggingErrorReceiver
extends ErrorReceiver {
    private final Log log;
    private final boolean verbose;
    private final String messagePrefix;

    public LoggingErrorReceiver(String messagePrefix, Log log, boolean verbose) {
        this.log = log;
        this.verbose = verbose;
        this.messagePrefix = messagePrefix;
    }

    public void warning(SAXParseException saxex) {
        this.log.warn((CharSequence)this.getMessage(saxex), (Throwable)saxex);
    }

    public void error(SAXParseException saxex) {
        this.log.error((CharSequence)this.getMessage(saxex), (Throwable)saxex);
    }

    public void fatalError(SAXParseException saxex) {
        this.log.error((CharSequence)this.getMessage(saxex), (Throwable)saxex);
    }

    public void info(SAXParseException saxex) {
        if (this.verbose) {
            this.log.info((CharSequence)this.getMessage(saxex));
        }
    }

    private String getMessage(SAXParseException ex) {
        int row = ex.getLineNumber();
        int col = ex.getColumnNumber();
        String sys = ex.getSystemId();
        String pub = ex.getPublicId();
        return this.messagePrefix + "Location [" + (sys != null ? " " + sys : "") + (pub != null ? " " + pub : "") + (row > 0 ? "{" + row + (col > 0 ? "," + col : "") + "}" : "") + "].";
    }
}

