/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mjiip.v_2;

import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.SpecVersion;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.jvnet.jaxb2.maven2.OptionsConfiguration;
import org.jvnet.jaxb2.maven2.util.StringUtils;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsFactory
implements org.jvnet.jaxb2.maven2.OptionsFactory<Options> {
    public Options createOptions(OptionsConfiguration optionsConfiguration) throws MojoExecutionException {
        Options options = new Options();
        options.verbose = optionsConfiguration.isVerbose();
        options.debugMode = optionsConfiguration.isDebugMode();
        options.classpaths.addAll(optionsConfiguration.getPlugins());
        options.target = this.createSpecVersion(optionsConfiguration.getSpecVersion());
        String encoding = optionsConfiguration.getEncoding();
        if (encoding != null) {
            options.encoding = this.createEncoding(encoding);
        }
        options.setSchemaLanguage(this.createLanguage(optionsConfiguration.getSchemaLanguage()));
        for (InputSource grammar : optionsConfiguration.getGrammars()) {
            options.addGrammar(grammar);
        }
        for (InputSource bindFile : optionsConfiguration.getBindFiles()) {
            options.addBindFile(bindFile);
        }
        options.entityResolver = optionsConfiguration.getCatalogResolver();
        for (URL catalog : optionsConfiguration.getCatalogs()) {
            if (catalog == null) continue;
            try {
                if (options.entityResolver == null) {
                    CatalogManager.getStaticManager().setIgnoreMissingProperties(true);
                    options.entityResolver = new CatalogResolver(true);
                }
                ((CatalogResolver)options.entityResolver).getCatalog().parseCatalog(catalog);
            }
            catch (IOException ioex) {
                throw new MojoExecutionException(MessageFormat.format("Error parsing catalog [{0}].", catalog.toExternalForm()), (Exception)ioex);
            }
        }
        options.defaultPackage = optionsConfiguration.getGeneratePackage();
        options.targetDir = optionsConfiguration.getGenerateDirectory();
        options.strictCheck = optionsConfiguration.isStrict();
        options.readOnly = optionsConfiguration.isReadOnly();
        options.packageLevelAnnotations = optionsConfiguration.isPackageLevelAnnotations();
        options.noFileHeader = optionsConfiguration.isNoFileHeader();
        options.enableIntrospection = optionsConfiguration.isEnableIntrospection();
        options.disableXmlSecurity = optionsConfiguration.isDisableXmlSecurity();
        if (optionsConfiguration.getAccessExternalSchema() != null) {
            System.setProperty("javax.xml.accessExternalSchema", optionsConfiguration.getAccessExternalSchema());
        }
        if (optionsConfiguration.getAccessExternalDTD() != null) {
            System.setProperty("javax.xml.accessExternalDTD", optionsConfiguration.getAccessExternalDTD());
        }
        options.contentForWildcard = optionsConfiguration.isContentForWildcard();
        if (optionsConfiguration.isExtension()) {
            options.compatibilityMode = 2;
        }
        List arguments = optionsConfiguration.getArguments();
        try {
            options.parseArguments(arguments.toArray(new String[arguments.size()]));
        }
        catch (BadCommandLineException bclex) {
            throw new MojoExecutionException("Error parsing the command line [" + arguments + "]", (Exception)((Object)bclex));
        }
        return options;
    }

    private SpecVersion createSpecVersion(String specVersion) {
        if (specVersion == null) {
            return SpecVersion.LATEST;
        }
        SpecVersion sv = SpecVersion.parse((String)specVersion);
        return sv == null ? SpecVersion.LATEST : sv;
    }

    private String createEncoding(String encoding) throws MojoExecutionException {
        if (encoding == null) {
            return null;
        }
        try {
            if (!Charset.isSupported(encoding)) {
                throw new MojoExecutionException(MessageFormat.format("Unsupported encoding [{0}].", encoding));
            }
            return encoding;
        }
        catch (IllegalCharsetNameException icne) {
            throw new MojoExecutionException(MessageFormat.format("Unsupported encoding [{0}].", encoding));
        }
    }

    private Language createLanguage(String schemaLanguage) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)schemaLanguage)) {
            return null;
        }
        if ("AUTODETECT".equalsIgnoreCase(schemaLanguage)) {
            return null;
        }
        if ("XMLSCHEMA".equalsIgnoreCase(schemaLanguage)) {
            return Language.XMLSCHEMA;
        }
        if ("DTD".equalsIgnoreCase(schemaLanguage)) {
            return Language.DTD;
        }
        if ("RELAXNG".equalsIgnoreCase(schemaLanguage)) {
            return Language.RELAXNG;
        }
        if ("RELAXNG_COMPACT".equalsIgnoreCase(schemaLanguage)) {
            return Language.RELAXNG_COMPACT;
        }
        if ("WSDL".equalsIgnoreCase(schemaLanguage)) {
            return Language.WSDL;
        }
        throw new MojoExecutionException(MessageFormat.format("Unknown schemaLanguage [{0}].", schemaLanguage));
    }
}

