/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.jvnet.jaxb2.maven2.Artifact;
import org.jvnet.jaxb2.maven2.XJC2MojoClassLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="generate")
@MojoPhase(value="generate-sources")
@MojoRequiresDependencyResolution
public class XJC2Mojo
extends AbstractMojo {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private MavenProjectBuilder mavenProjectBuilder;
    protected List schemaFiles = new ArrayList();
    protected List bindingFiles = new ArrayList();
    private String schemaLanguage;
    private File schemaDirectory;
    private String[] schemaIncludes = new String[]{"*.xsd"};
    private String[] schemaExcludes;
    private File bindingDirectory;
    private String[] bindingIncludes = new String[]{"*.xjb"};
    private String[] bindingExcludes;
    private boolean disableDefaultExcludes;
    private File catalog;
    private String catalogResolver = CatalogResolver.class.getName();
    private String generatePackage;
    private File generateDirectory;
    private boolean readOnly;
    private boolean extension;
    private boolean strict;
    private boolean writeCode = true;
    private boolean verbose;
    private boolean debug;
    private List<String> args = new LinkedList<String>();
    private boolean forceRegenerate;
    private boolean removeOldOutput;
    private String[] otherDepends;
    private File episodeFile;
    private boolean episode = true;
    private List classpathElements;
    private MavenProject project;
    private Artifact[] plugins;
    private Artifact[] episodes;

    protected String getVersionFromDependencies(Artifact artifact, Set<org.apache.maven.artifact.Artifact> dependencies) {
        if (dependencies == null) {
            return null;
        }
        for (org.apache.maven.artifact.Artifact dependency : dependencies) {
            if (!artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId())) continue;
            return dependency.getVersion();
        }
        return null;
    }

    @MojoComponent
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    @MojoComponent
    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    @MojoParameter(expression="${localRepository}", required=true)
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    @MojoComponent(role="org.apache.maven.project.MavenProjectBuilder")
    public MavenProjectBuilder getMavenProjectBuilder() {
        return this.mavenProjectBuilder;
    }

    public void setMavenProjectBuilder(MavenProjectBuilder mavenProjectBuilder) {
        this.mavenProjectBuilder = mavenProjectBuilder;
    }

    @MojoParameter(expression="${maven.xjc2.schemaLanguage}")
    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    @MojoParameter(defaultValue="src/main/resources", expression="${maven.xjc2.schemaDirectory}", required=true)
    public File getSchemaDirectory() {
        return this.schemaDirectory;
    }

    public void setSchemaDirectory(File schemaDirectory) {
        this.schemaDirectory = schemaDirectory;
    }

    @MojoParameter
    public String[] getSchemaIncludes() {
        return this.schemaIncludes;
    }

    public void setSchemaIncludes(String[] schemaIncludes) {
        this.schemaIncludes = schemaIncludes;
    }

    @MojoParameter
    public String[] getSchemaExcludes() {
        return this.schemaExcludes;
    }

    public void setSchemaExcludes(String[] schemaExcludes) {
        this.schemaExcludes = schemaExcludes;
    }

    public void setBindingDirectory(File bindingDirectory) {
        this.bindingDirectory = bindingDirectory;
    }

    @MojoParameter(expression="${maven.xjc2.bindingDirectory}")
    public File getBindingDirectory() {
        return this.bindingDirectory;
    }

    @MojoParameter
    public String[] getBindingIncludes() {
        return this.bindingIncludes;
    }

    public void setBindingIncludes(String[] bindingIncludes) {
        this.bindingIncludes = bindingIncludes;
    }

    @MojoParameter
    public String[] getBindingExcludes() {
        return this.bindingExcludes;
    }

    public void setBindingExcludes(String[] bindingExcludes) {
        this.bindingExcludes = bindingExcludes;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.disableDefaultExcludes}")
    public boolean getDisableDefaultExcludes() {
        return this.disableDefaultExcludes;
    }

    public void setDisableDefaultExcludes(boolean disableDefaultExcludes) {
        this.disableDefaultExcludes = disableDefaultExcludes;
    }

    @MojoParameter(expression="${maven.xjc2.catalog}")
    public File getCatalog() {
        return this.catalog;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    @MojoParameter(expression="${maven.xjc2.catalogResolver}")
    public String getCatalogResolver() {
        return this.catalogResolver;
    }

    public void setCatalogResolver(String catalogResolver) {
        this.catalogResolver = catalogResolver;
    }

    @MojoParameter(expression="${maven.xjc2.generatePackage}")
    public String getGeneratePackage() {
        return this.generatePackage;
    }

    public void setGeneratePackage(String generatePackage) {
        this.generatePackage = generatePackage;
    }

    @MojoParameter(defaultValue="${project.build.directory}/generated-sources/xjc", expression="${maven.xjc2.generateDirectory}", required=true)
    public File getGenerateDirectory() {
        return this.generateDirectory;
    }

    public void setGenerateDirectory(File generateDirectory) {
        this.generateDirectory = generateDirectory;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.readOnly}")
    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.extension}")
    public boolean getExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    @MojoParameter(defaultValue="true", expression="${maven.xjc2.strict}")
    public boolean getStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @MojoParameter(defaultValue="true", expression="${maven.xjc2.writeCode}")
    public boolean getWriteCode() {
        return this.writeCode;
    }

    public void setWriteCode(boolean writeCode) {
        this.writeCode = writeCode;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.verbose}")
    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.debug}")
    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @MojoParameter
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.addAll(args);
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.forceRegenerate}")
    public boolean getForceRegenerate() {
        return this.forceRegenerate;
    }

    public void setForceRegenerate(boolean forceRegenerate) {
        this.forceRegenerate = forceRegenerate;
    }

    @MojoParameter(defaultValue="true", expression="${maven.xjc2.removeOldOutput}")
    public boolean getRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public void setRemoveOldOutput(boolean removeOldOutput) {
        this.removeOldOutput = removeOldOutput;
    }

    @MojoParameter
    public String[] getOtherDepends() {
        return this.otherDepends;
    }

    public void setOtherDepends(String[] otherDepends) {
        this.otherDepends = otherDepends;
    }

    @MojoParameter(expression="${maven.xjc2.episodeFile}", defaultValue="${project.build.directory}/generated-sources/xjc/META-INF/sun-jaxb.episode")
    public File getEpisodeFile() {
        return this.episodeFile;
    }

    public void setEpisodeFile(File episodeFile) {
        this.episodeFile = episodeFile;
    }

    @MojoParameter(expression="${maven.xjc2.episode}", defaultValue="true")
    public boolean getEpisode() {
        return this.episode;
    }

    public void setEpisode(boolean episode) {
        this.episode = episode;
    }

    @MojoParameter(expression="${project.compileClasspathElements}", required=true, readonly=true)
    public List getClasspathElements() {
        return this.classpathElements;
    }

    public void setClasspathElements(List classpathElements) {
        this.classpathElements = classpathElements;
    }

    @MojoParameter(expression="${project}", required=true, readonly=true)
    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @MojoParameter
    public Artifact[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Artifact[] plugins) {
        this.plugins = plugins;
    }

    @MojoParameter
    public Artifact[] getEpisodes() {
        return this.episodes;
    }

    public void setEpisodes(Artifact[] episodes) {
        this.episodes = episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getProjectDepsClassLoader(oldCL));
            try {
                this.setupLogging();
                Options xjcOpts = this.setupOptions();
                if (this.getVerbose()) {
                    this.logSettings();
                }
                this.updateMavenPaths();
                if (!this.getForceRegenerate() && this.isUpdToDate()) {
                    this.getLog().info((CharSequence)"Skipped XJC execution.  Generated sources were up-to-date.");
                    return;
                }
                if (this.getRemoveOldOutput()) {
                    if (this.getGenerateDirectory().exists()) {
                        try {
                            FileUtils.deleteDirectory((File)this.getGenerateDirectory());
                            this.getLog().info((CharSequence)("Removed old generateDirectory '" + this.getGenerateDirectory() + "'."));
                        }
                        catch (IOException ex) {
                            this.getLog().warn((CharSequence)("Failed to remove old generateDirectory '" + this.getGenerateDirectory() + "' due to: " + ex));
                        }
                    } else if (this.getVerbose()) {
                        this.getLog().info((CharSequence)("Skipped removal of old generateDirectory '" + this.getGenerateDirectory() + "' since it didn't exist."));
                    }
                }
                if (this.getGenerateDirectory() != null && !this.getGenerateDirectory().exists()) {
                    this.getGenerateDirectory().mkdirs();
                }
                if (this.getEpisode() && this.getEpisodeFile() != null) {
                    File parentFile = this.getEpisodeFile().getParentFile();
                    parentFile.mkdirs();
                }
                this.runXJC(xjcOpts);
                this.getLog().info((CharSequence)("Succesfully generated output to: " + xjcOpts.targetDir));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        catch (RuntimeException ex) {
            this.getLog().info((CharSequence)"Mojo options will be logged due to an unexpected error...");
            this.logSettings();
            throw ex;
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
    }

    protected Options setupOptions() throws MojoExecutionException {
        Options xjcOpts = new Options();
        xjcOpts.classpaths.addAll(this.getPluginURLs());
        xjcOpts.verbose = this.getVerbose();
        xjcOpts.debugMode = this.getDebug();
        if (!XJC2Mojo.isDefined(this.getSchemaLanguage(), 1)) {
            this.setSchemaLanguage("AUTODETECT");
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)"The <schemaLanguage> setting was not defined, assuming 'AUTODETECT'.");
            }
        } else if (!"AUTODETECT".equalsIgnoreCase(this.getSchemaLanguage())) {
            if ("XMLSCHEMA".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
            } else if ("DTD".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.DTD);
            } else if ("RELAXNG".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.RELAXNG);
            } else if ("RELAXNG_COMPACT".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.RELAXNG_COMPACT);
            } else if ("WSDL".equalsIgnoreCase(this.getSchemaLanguage())) {
                xjcOpts.setSchemaLanguage(Language.WSDL);
            } else {
                this.logSettings();
                throw new MojoExecutionException("Unknown <schemaLanguage> '" + this.getSchemaLanguage() + "'!");
            }
        }
        List files = this.gatherFiles(this.getSchemaDirectory(), this.getSchemaIncludes(), this.getSchemaExcludes());
        Iterator it = files.iterator();
        while (it.hasNext()) {
            xjcOpts.addGrammar(XJC2Mojo.getInputSource((File)it.next()));
        }
        this.schemaFiles.addAll(files);
        if (this.schemaFiles.size() == 0) {
            this.logSettings();
            throw new MojoExecutionException("No schemas found inside the <schemaDirectory> '" + this.getSchemaDirectory() + "'!");
        }
        if (!XJC2Mojo.isDefined(this.getBindingDirectory(), 1)) {
            this.setBindingDirectory(this.getSchemaDirectory());
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)("The <bindingDirectory> setting was not defined, assuming the same as <schemaDirectory>: " + this.getSchemaDirectory() + ""));
            }
        }
        files = this.gatherFiles(this.getBindingDirectory(), this.getBindingIncludes(), this.getBindingExcludes());
        it = files.iterator();
        while (it.hasNext()) {
            xjcOpts.addBindFile(XJC2Mojo.getInputSource((File)it.next()));
        }
        this.bindingFiles.addAll(files);
        if (XJC2Mojo.isDefined(this.getCatalog(), 1)) {
            try {
                xjcOpts.addCatalog(this.getCatalog());
            }
            catch (IOException ex) {
                this.logSettings();
                throw new MojoExecutionException("Error while setting the <catalog> to '" + this.getCatalog() + "'!", (Exception)ex);
            }
        }
        this.configureCatalogResolver(xjcOpts);
        xjcOpts.defaultPackage = this.getGeneratePackage();
        xjcOpts.targetDir = this.getGenerateDirectory();
        xjcOpts.strictCheck = this.getStrict();
        xjcOpts.readOnly = this.getReadOnly();
        if (this.getExtension()) {
            xjcOpts.compatibilityMode = 2;
        }
        this.setupCmdLineArgs(xjcOpts);
        return xjcOpts;
    }

    protected void configureCatalogResolver(Options options) throws MojoExecutionException {
        if (this.catalogResolver != null) {
            try {
                Class<?> draftCatalogResolverClass = Thread.currentThread().getContextClassLoader().loadClass(this.catalogResolver);
                if (!CatalogResolver.class.isAssignableFrom(draftCatalogResolverClass)) {
                    throw new MojoExecutionException("Specified catalog resolver class [" + this.catalogResolver + "] could not be casted to [" + CatalogResolver.class + "].");
                }
                Class<?> catalogResolverClass = draftCatalogResolverClass;
                CatalogResolver catalogResolverInstance = (CatalogResolver)catalogResolverClass.newInstance();
                options.entityResolver = catalogResolverInstance;
            }
            catch (ClassNotFoundException cnfex) {
                throw new MojoExecutionException("Could not find specified catalog resolver class [" + this.catalogResolver + "].", (Exception)cnfex);
            }
            catch (InstantiationException iex) {
                throw new MojoExecutionException("Could not instantiate catalog resolver class [" + this.catalogResolver + "].", (Exception)iex);
            }
            catch (IllegalAccessException iaex) {
                throw new MojoExecutionException("Could not instantiate catalog resolver class [" + this.catalogResolver + "].", (Exception)iaex);
            }
        }
    }

    protected void setupCmdLineArgs(Options xjcOpts) throws MojoExecutionException {
        if (this.getEpisode() && this.getEpisodeFile() != null) {
            this.getArgs().add("-episode");
            this.getArgs().add(this.getEpisodeFile().getAbsolutePath());
        }
        if (this.getEpisodes() != null) {
            Collection<File> episodeFiles = this.getEpisodeFiles();
            for (File episodeFile : episodeFiles) {
                this.getArgs().add(episodeFile.getAbsolutePath());
            }
        }
        if (!this.getArgs().isEmpty()) {
            try {
                xjcOpts.parseArguments(this.getArgs().toArray(new String[this.getArgs().size()]));
            }
            catch (BadCommandLineException ex) {
                throw new MojoExecutionException("Error while setting CmdLine <args> options '" + this.getArgs() + "'!", (Exception)((Object)ex));
            }
        }
    }

    protected void setupLogging() {
        Log log = this.getLog();
        if (!this.getVerbose()) {
            this.setVerbose(log.isDebugEnabled());
        }
        if (this.getVerbose()) {
            System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        }
    }

    protected void logSettings() {
        StringBuffer sb = new StringBuffer();
        sb.append("Plugin's mojo parameters: ");
        this.logUserSettings(sb);
        sb.append("\nCalculated options: ");
        this.logCalcSettings(sb);
        this.getLog().info((CharSequence)sb);
    }

    protected void logUserSettings(StringBuffer sb) {
        sb.append("\n\tschemaLanguage: " + this.getSchemaLanguage());
        sb.append("\n\tschemaDirectory: " + this.getSchemaDirectory());
        sb.append("\n\tschemaIncludes: " + XJC2Mojo.recursiveToString(this.getSchemaIncludes()));
        sb.append("\n\tschemaExcludes: " + XJC2Mojo.recursiveToString(this.getSchemaExcludes()));
        sb.append("\n\tbindingDirectory: " + this.getBindingDirectory());
        sb.append("\n\tbindingIncludes: " + XJC2Mojo.recursiveToString(this.getBindingIncludes()));
        sb.append("\n\tbindingExcludes: " + XJC2Mojo.recursiveToString(this.getBindingExcludes()));
        sb.append("\n\tdisableDefaultExcludes: " + this.getDisableDefaultExcludes());
        sb.append("\n\tcatalog: " + this.getCatalog());
        sb.append("\n\tdefaultPackage: " + this.getGeneratePackage());
        sb.append("\n\tdestinationDirectory: " + this.getGenerateDirectory());
        sb.append("\n\tforceRegenerate: " + this.getForceRegenerate());
        sb.append("\n\totherDepends: " + XJC2Mojo.recursiveToString(this.getOtherDepends()));
        sb.append("\n\tremoveOldOutput: " + this.getRemoveOldOutput());
        sb.append("\n\twriteCode: " + this.getWriteCode());
        sb.append("\n\treadOnly: " + this.getReadOnly());
        sb.append("\n\textension: " + this.getExtension());
        sb.append("\n\tstrict: " + this.getStrict());
        sb.append("\n\tverbose: " + this.getVerbose());
        sb.append("\n\tdebug: " + this.getDebug());
        sb.append("\n\txjcArgs: " + XJC2Mojo.recursiveToString(this.getArgs()));
    }

    protected void logCalcSettings(StringBuffer sb) {
        sb.append("\n\tSchema File(s): " + XJC2Mojo.recursiveToString(this.schemaFiles));
        sb.append("\n\tBinding File(s): " + XJC2Mojo.recursiveToString(this.bindingFiles));
        sb.append("\n\tClassPath: " + XJC2Mojo.recursiveToString(this.getClasspathElements()));
    }

    protected boolean isUpdToDate() throws MojoExecutionException {
        ArrayList dependsFiles = new ArrayList();
        ArrayList producesFiles = new ArrayList();
        this.gatherDependsFiles(dependsFiles);
        if (this.getVerbose() && !this.getDebug()) {
            this.getLog().info((CharSequence)("Checking up-to-date depends: " + XJC2Mojo.recursiveToString(dependsFiles)));
        }
        this.gatherProducesFiles(producesFiles);
        if (this.getVerbose() && !this.getDebug()) {
            this.getLog().info((CharSequence)("Checking up-to-date produces: " + XJC2Mojo.recursiveToString(producesFiles)));
        }
        long inputTimeStamp = this.findLastModified(dependsFiles, true);
        long destTimeStamp = this.findLastModified(producesFiles, false);
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)("Depends timeStamp: " + inputTimeStamp + ", produces timestamp: " + destTimeStamp));
        }
        return inputTimeStamp < destTimeStamp;
    }

    protected void gatherDependsFiles(List inputFiles) {
        inputFiles.addAll(this.schemaFiles);
        inputFiles.addAll(this.bindingFiles);
        if (this.getCatalog() != null) {
            inputFiles.add(this.getCatalog());
        }
        if (this.getProject() != null) {
            inputFiles.add(this.getProject().getFile());
        }
        if (this.getOtherDepends() != null) {
            inputFiles.addAll(Arrays.asList(this.getOtherDepends()));
        }
    }

    protected void gatherProducesFiles(List destFiles) throws MojoExecutionException {
        if (this.getGenerateDirectory().exists()) {
            if (!this.getGenerateDirectory().isDirectory()) {
                this.getLog().warn((CharSequence)("The <generateDirectory>='" + this.getGenerateDirectory() + "' is not a directory!  Probably XJC will fail..."));
            } else {
                destFiles.addAll(this.gatherFiles(this.getGenerateDirectory(), new String[]{"**/*.java", "**/bgm.ser", "**/jaxb.properties"}, null));
            }
        }
    }

    private ClassLoader getProjectDepsClassLoader(ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.getClasspathElements() != null) {
            for (String pathElem : this.getClasspathElements()) {
                try {
                    urls.add(new File(pathElem).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Internal classpath element '" + pathElem + "' is was skiped due to: " + XJC2Mojo.getAllExMsgs(e, true)));
                }
            }
        }
        XJC2MojoClassLoader cl = new XJC2MojoClassLoader(urls.toArray(new URL[urls.size()]), parent);
        return cl;
    }

    protected void runXJC(Options xjcOpts) throws MojoExecutionException {
        JaxbErrorReceiver4Mvn errorReceiver = new JaxbErrorReceiver4Mvn();
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Parsing input schema(s)...");
        }
        errorReceiver.stage = "parsing";
        Model model = ModelLoader.load((Options)xjcOpts, (JCodeModel)new JCodeModel(), (ErrorReceiver)errorReceiver);
        if (model == null) {
            throw new MojoExecutionException("Unable to parse input schema(s).  Error messages should have been provided.");
        }
        try {
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)"Compiling input schema(s)...");
            }
            errorReceiver.stage = "compiling";
            Outline outline = model.generateCode(xjcOpts, (ErrorReceiver)errorReceiver);
            if (outline == null) {
                throw new MojoExecutionException("Failed to compile input schema(s)!  Error messages should have been provided.");
            }
            if (this.getWriteCode()) {
                if (this.getVerbose()) {
                    this.getLog().info((CharSequence)("Writing output to: " + xjcOpts.targetDir));
                }
                model.codeModel.build((CodeWriter)new JaxbCodeWriter4Mvn(xjcOpts.createCodeWriter()));
            } else if (this.getVerbose()) {
                this.getLog().info((CharSequence)"Code will not be written.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write files: " + e.getMessage(), (Exception)e);
        }
    }

    protected void updateMavenPaths() {
        String generatedDirectoryPath;
        String episodeFilePath;
        if (this.getProject() != null) {
            this.getProject().addCompileSourceRoot(this.getGenerateDirectory().getPath());
        }
        Resource jaxbRes = new Resource();
        jaxbRes.setDirectory(this.getGenerateDirectory().getPath());
        jaxbRes.addInclude("**/jaxb.properties");
        jaxbRes.addInclude("**/bgm.ser");
        if (this.getProject() != null) {
            this.getProject().addResource(jaxbRes);
        }
        if (this.getEpisode() && this.getEpisodeFile() != null && (episodeFilePath = this.getEpisodeFile().getAbsolutePath()).startsWith((generatedDirectoryPath = this.getGenerateDirectory().getAbsolutePath()) + File.separator)) {
            String path = episodeFilePath.substring(generatedDirectoryPath.length() + 1);
            Resource resource = new Resource();
            resource.setDirectory(generatedDirectoryPath);
            resource.addInclude(path);
            this.getProject().addResource(resource);
        }
    }

    protected long findLastModified(List files, boolean oldest) {
        long timeStamp = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (Object no : files) {
            long fileModifTime;
            if (no == null) continue;
            if (no instanceof String) {
                String sdep = (String)no;
                try {
                    URL url = new URL(sdep);
                    URLConnection uCon = url.openConnection();
                    uCon.setUseCaches(false);
                    fileModifTime = uCon.getLastModified();
                }
                catch (MalformedURLException e) {
                    fileModifTime = new File(sdep).lastModified();
                }
                catch (IOException ex) {
                    fileModifTime = oldest ? Long.MIN_VALUE : Long.MAX_VALUE;
                    this.getLog().warn((CharSequence)("Skipping URL '" + no + "' from up-to-date check due to error while opening connection: " + XJC2Mojo.getAllExMsgs(ex, true)));
                }
            } else {
                fileModifTime = ((File)no).lastModified();
            }
            if (this.getDebug()) {
                this.getLog().info((CharSequence)((oldest ? "Depends " : "Produces ") + no + ": " + new Date(fileModifTime)));
            }
            if (!(fileModifTime > timeStamp ^ !oldest)) continue;
            timeStamp = fileModifTime;
        }
        if (timeStamp == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        if (timeStamp == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return timeStamp;
    }

    protected static InputSource getInputSource(File f) {
        try {
            return new InputSource(f.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            return new InputSource(f.getPath());
        }
    }

    protected List gatherFiles(File baseDir, String[] includesPattern, String[] excludesPattern) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir.getAbsoluteFile());
        scanner.setIncludes(includesPattern);
        scanner.setExcludes(this.getExcludes(excludesPattern));
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>();
        String[] incFiles = scanner.getIncludedFiles();
        for (int i = 0; i < incFiles.length; ++i) {
            String name = incFiles[i];
            try {
                File file = new File(baseDir, name);
                files.add(file.getCanonicalFile());
                continue;
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Unable to canonize the file [" + name + "]");
            }
        }
        return files;
    }

    protected String[] getExcludes(String[] origExcludes) {
        if (origExcludes == null) {
            return null;
        }
        ArrayList<String> ex = new ArrayList<String>(Arrays.asList(origExcludes));
        List newExc = this.getExcludes(ex);
        return newExc.toArray(new String[newExc.size()]);
    }

    protected List getExcludes(List origExcludes) {
        if (origExcludes == null || this.getDisableDefaultExcludes()) {
            return origExcludes;
        }
        origExcludes.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        return origExcludes;
    }

    protected static boolean isDefined(Object setting, int minimumLength) {
        boolean defined;
        boolean bl = defined = setting != null;
        defined = setting instanceof Object[] ? defined && ((Object[])setting).length >= minimumLength : (setting instanceof Collection ? defined && ((Collection)setting).size() >= minimumLength : defined && setting.toString().trim().length() >= minimumLength);
        return defined;
    }

    protected static String recursiveToString(Object setting) {
        if (setting == null) {
            return "null";
        }
        if (setting instanceof Collection) {
            Collection collection = (Collection)setting;
            setting = collection.toArray();
        }
        if (setting instanceof Object[]) {
            Object[] settingArray = setting;
            if (settingArray.length == 0) {
                return "[]";
            }
            StringBuffer result = new StringBuffer();
            result.append('[');
            result.append(XJC2Mojo.recursiveToString(settingArray[0]));
            for (int index = 1; index < settingArray.length; ++index) {
                result.append(", ");
                result.append(XJC2Mojo.recursiveToString(settingArray[index]));
            }
            result.append(']');
            return result.toString();
        }
        return setting.toString();
    }

    public static String getAllExMsgs(Throwable ex, boolean includeExName) {
        Exception embeded;
        StringBuffer sb = new StringBuffer(includeExName ? ex.toString() : ex.getLocalizedMessage());
        Throwable cause = ex.getCause();
        Exception exception = embeded = ex instanceof SAXParseException ? ((SAXParseException)ex).getException() : null;
        if (cause == embeded && cause != null || cause != null) {
            XJC2Mojo.getAllCauseExMsgs(cause, includeExName, sb);
        } else if (embeded != null) {
            XJC2Mojo.getAllCauseExMsgs(embeded, includeExName, sb);
        }
        return sb.toString();
    }

    private static void getAllCauseExMsgs(Throwable ex, boolean includeExName, StringBuffer sb) {
        do {
            sb.append("\nCaused by: " + (includeExName ? ex.toString() : ex.getLocalizedMessage()));
        } while ((ex = ex.getCause()) != null);
    }

    public static String getAllExStackTraces(Throwable ex) {
        Exception embeded;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        Throwable cause = ex.getCause();
        Exception exception = embeded = ex instanceof SAXParseException ? ((SAXParseException)ex).getException() : null;
        if (embeded != null && cause != embeded) {
            pw.append("Embedded ex:");
            embeded.printStackTrace(pw);
        }
        return sw.toString();
    }

    public Collection<URL> getPluginURLs() throws MojoExecutionException {
        HashSet<URL> pluginURLs = new HashSet<URL>();
        for (File artifactFile : this.getArtifactFiles(this.getPlugins(), true)) {
            try {
                pluginURLs.add(artifactFile.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new MojoExecutionException("Could not retrieve URL for a file.", (Exception)ex);
            }
        }
        return pluginURLs;
    }

    public Collection<File> getEpisodeFiles() throws MojoExecutionException {
        return this.getArtifactFiles(this.getEpisodes(), false);
    }

    protected Collection<File> getArtifactFiles(Artifact[] artifacts, boolean resolveDependencies) throws MojoExecutionException {
        HashSet<File> files = new HashSet<File>();
        Set projectDependencies = this.getProject().getDependencyArtifacts();
        if (artifacts != null) {
            for (int i = 0; i < artifacts.length; ++i) {
                org.apache.maven.artifact.Artifact artifact = null;
                if (artifacts[i].getVersion() != null || projectDependencies == null) {
                    artifact = artifacts[i].toArtifact(this.getArtifactFactory());
                } else {
                    Artifact withVersion = new Artifact();
                    withVersion.setGroupId(artifacts[i].getGroupId());
                    withVersion.setArtifactId(artifacts[i].getArtifactId());
                    withVersion.setVersion(this.getVersionFromDependencies(artifacts[i], projectDependencies));
                    this.getLog().info((CharSequence)("No version specified for plugin/episode-artifact. Resolving version from dependencies yields " + withVersion.toString()));
                    artifact = withVersion.toArtifact(this.getArtifactFactory());
                }
                try {
                    this.getArtifactResolver().resolve(artifact, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
                    files.add(artifact.getFile());
                    if (!resolveDependencies || artifact.isOptional()) continue;
                    Set<org.apache.maven.artifact.Artifact> artifactDependencies = this.resolveArtifactDependencies(artifact);
                    for (org.apache.maven.artifact.Artifact artifactDependency : artifactDependencies) {
                        files.add(artifactDependency.getFile());
                    }
                    continue;
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException("Error attempting to download the plugin: " + artifacts[i], (Exception)((Object)e));
                }
                catch (ArtifactNotFoundException e) {
                    throw new MojoExecutionException("Plugin doesn't exist: " + artifacts[i], (Exception)((Object)e));
                }
                catch (ProjectBuildingException e) {
                    throw new MojoExecutionException("Error processing the plugin dependency POM.", (Exception)((Object)e));
                }
                catch (InvalidDependencyVersionException e) {
                    throw new MojoExecutionException("Invalid plugin dependency version.", (Exception)((Object)e));
                }
            }
        }
        return files;
    }

    protected Set<org.apache.maven.artifact.Artifact> resolveArtifactDependencies(org.apache.maven.artifact.Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException, ProjectBuildingException, InvalidDependencyVersionException {
        org.apache.maven.artifact.Artifact pomArtifact = this.getArtifactFactory().createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.getMavenProjectBuilder().buildFromRepository(pomArtifact, this.getProject().getRemoteArtifactRepositories(), this.getLocalRepository());
        HashSet<org.apache.maven.artifact.Artifact> artifacts = new HashSet<org.apache.maven.artifact.Artifact>();
        Set<org.apache.maven.artifact.Artifact> dependencyArtifacts = this.resolveDependencyArtifacts(pomProject);
        artifacts.addAll(dependencyArtifacts);
        if (!dependencyArtifacts.isEmpty()) {
            for (org.apache.maven.artifact.Artifact a : dependencyArtifacts) {
                if (a.isOptional()) continue;
                artifacts.addAll(this.resolveArtifactDependencies(a));
            }
        }
        return artifacts;
    }

    protected Set<org.apache.maven.artifact.Artifact> resolveDependencyArtifacts(MavenProject theProject) throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        HashSet<org.apache.maven.artifact.Artifact> as = new HashSet<org.apache.maven.artifact.Artifact>();
        Set artifacts = theProject.createArtifacts(this.getArtifactFactory(), "runtime", (ArtifactFilter)new ScopeArtifactFilter("runtime"));
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            if (artifact.isOptional()) continue;
            try {
                this.getArtifactResolver().resolve(artifact, this.getProject().getRemoteArtifactRepositories(), this.getLocalRepository());
                as.add(artifact);
            }
            catch (ArtifactNotFoundException arex) {
                this.getLog().warn((CharSequence)"Error resolving plugin dependency.", (Throwable)arex);
            }
            catch (ArtifactResolutionException arex) {
                this.getLog().warn((CharSequence)"Error resolving plugin dependency.", (Throwable)arex);
            }
        }
        return as;
    }

    private class JaxbCodeWriter4Mvn
    extends CodeWriter {
        private final CodeWriter output;

        public JaxbCodeWriter4Mvn(CodeWriter output) {
            this.output = output;
        }

        public Writer openSource(JPackage pkg, String fileName) throws IOException {
            if (XJC2Mojo.this.getVerbose()) {
                if (pkg.isUnnamed()) {
                    XJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + fileName));
                } else {
                    XJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName));
                }
            }
            return this.output.openSource(pkg, fileName);
        }

        public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
            if (XJC2Mojo.this.getVerbose()) {
                if (pkg.isUnnamed()) {
                    XJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + fileName));
                } else {
                    XJC2Mojo.this.getLog().info((CharSequence)("XJC writing: " + pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName));
                }
            }
            return this.output.openBinary(pkg, fileName);
        }

        public void close() throws IOException {
            this.output.close();
        }
    }

    protected class JaxbErrorReceiver4Mvn
    extends ErrorReceiver {
        public String stage = "processing";

        protected JaxbErrorReceiver4Mvn() {
        }

        public void warning(SAXParseException e) {
            XJC2Mojo.this.getLog().warn((CharSequence)this.makeMessage(e, true));
        }

        public void error(SAXParseException e) {
            XJC2Mojo.this.getLog().error((CharSequence)this.makeMessage(e, true));
        }

        public void fatalError(SAXParseException e) {
            XJC2Mojo.this.getLog().error((CharSequence)this.makeMessage(e, true));
        }

        public void info(SAXParseException e) {
            if (XJC2Mojo.this.getVerbose()) {
                XJC2Mojo.this.getLog().info((CharSequence)this.makeMessage(e, false));
            }
        }

        private String makeMessage(SAXParseException ex, boolean printExName) {
            int row = ex.getLineNumber();
            int col = ex.getColumnNumber();
            String sys = ex.getSystemId();
            String pub = ex.getPublicId();
            String exString = XJC2Mojo.this.getDebug() ? XJC2Mojo.getAllExStackTraces(ex) : XJC2Mojo.getAllExMsgs(ex, printExName);
            return "XJC while " + this.stage + " schema(s)" + (sys != null ? " " + sys : "") + (pub != null ? " " + pub : "") + (row > 0 ? "[" + row + (col > 0 ? "," + col : "") + "]" : "") + ": " + exString;
        }
    }
}

