/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.util;

import org.apache.commons.lang3.Validate;

public class ArrayUtils {
    public static <T> T asPrimitiveArray(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> arrayClass = array.getClass();
        Validate.isTrue((boolean)arrayClass.isArray(), (String)"Argument must be an array.", (Object[])new Object[0]);
        Class<?> componentType = arrayClass.getComponentType();
        if (componentType.isPrimitive()) {
            return (T)array;
        }
        if (Boolean.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Boolean[])((Boolean[])array));
        }
        if (Byte.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Byte[])((Byte[])array));
        }
        if (Character.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Character[])((Character[])array));
        }
        if (Short.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Short[])((Short[])array));
        }
        if (Integer.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Integer[])((Integer[])array));
        }
        if (Long.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Long[])((Long[])array));
        }
        if (Double.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Double[])((Double[])array));
        }
        if (Float.class.equals(componentType)) {
            return (T)org.apache.commons.lang3.ArrayUtils.toPrimitive((Float[])((Float[])array));
        }
        return (T)array;
    }

    public static <T> T[] asObjectArray(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> arrayClass = array.getClass();
        Validate.isTrue((boolean)arrayClass.isArray(), (String)"Argument must be an array.", (Object[])new Object[0]);
        Class<?> componentType = arrayClass.getComponentType();
        if (!componentType.isPrimitive()) {
            return (Object[])array;
        }
        if (Boolean.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((boolean[])((boolean[])array));
        }
        if (Byte.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((byte[])((byte[])array));
        }
        if (Character.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((char[])((char[])array));
        }
        if (Short.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((short[])((short[])array));
        }
        if (Integer.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((int[])((int[])array));
        }
        if (Long.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((long[])((long[])array));
        }
        if (Double.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((double[])((double[])array));
        }
        if (Float.TYPE.equals(componentType)) {
            return org.apache.commons.lang3.ArrayUtils.toObject((float[])((float[])array));
        }
        throw new AssertionError((Object)("Unexpected primitive type [" + componentType + "]."));
    }
}

