/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.test;

import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.test.AbstractEnglishLocaleTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractHealthDescriptorTest
extends AbstractEnglishLocaleTest {
    protected static final String WRONG_DESCRIPTION = "Wrong description";
    private static final String WRONG_MINIMUM_ANNOTATIONS = "Wrong minimum annotations";
    private static final String WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED = "Wrong value of isHealthyReportEnabled";
    private static final String WRONG_VALUE_OF_IS_THRESHOLD_ENABLED = "Wrong value of isThresholdEnabled";

    @Test
    public void testThresholds() {
        Assert.assertTrue((String)WRONG_VALUE_OF_IS_THRESHOLD_ENABLED, (boolean)this.createHealthDescriptor("0", "", "").isThresholdEnabled());
        Assert.assertTrue((String)WRONG_VALUE_OF_IS_THRESHOLD_ENABLED, (boolean)this.createHealthDescriptor("1", "", "").isThresholdEnabled());
        Assert.assertTrue((String)WRONG_VALUE_OF_IS_THRESHOLD_ENABLED, (boolean)this.createHealthDescriptor("100", "", "").isThresholdEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_THRESHOLD_ENABLED, (boolean)this.createHealthDescriptor("-1", "", "").isThresholdEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_THRESHOLD_ENABLED, (boolean)this.createHealthDescriptor("", "", "").isThresholdEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_THRESHOLD_ENABLED, (boolean)this.createHealthDescriptor(null, "", "").isThresholdEnabled());
    }

    @Test
    public void testHealthyThresholds() {
        Assert.assertTrue((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "0", "1").isHealthyReportEnabled());
        Assert.assertTrue((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "1", "2").isHealthyReportEnabled());
        Assert.assertTrue((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "10", "20").isHealthyReportEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "0", "0").isHealthyReportEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "1", "1").isThresholdEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "2", "1").isThresholdEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "2", "").isThresholdEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", "", "2").isThresholdEnabled());
        Assert.assertFalse((String)WRONG_VALUE_OF_IS_HEALTHY_REPORT_ENABLED, (boolean)this.createHealthDescriptor("", null, "2").isThresholdEnabled());
    }

    @Test
    public void testConversionOfThresholds() {
        Assert.assertEquals((String)WRONG_MINIMUM_ANNOTATIONS, (long)0L, (long)this.createHealthDescriptor("0", "", "").getLowerBoundOfThresholds());
        Assert.assertEquals((String)WRONG_MINIMUM_ANNOTATIONS, (long)1L, (long)this.createHealthDescriptor("1", "", "").getLowerBoundOfThresholds());
        Assert.assertEquals((String)WRONG_MINIMUM_ANNOTATIONS, (long)100L, (long)this.createHealthDescriptor("100", "", "").getLowerBoundOfThresholds());
    }

    @Test
    public void testConversionOfHealthiness() {
        Assert.assertEquals((String)"Wrong healthy annotations", (long)1L, (long)this.createHealthDescriptor("0", "1", "2").getHealthyAnnotations());
        Assert.assertEquals((String)"Wrong unhealthy annotations", (long)2L, (long)this.createHealthDescriptor("0", "1", "2").getUnHealthyAnnotations());
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyContractOfHealthy() {
        this.createHealthDescriptor("0", "-1", "0").getHealthyAnnotations();
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyContractOfUnHealthy() {
        this.createHealthDescriptor("0", "0", "-1").getUnHealthyAnnotations();
    }

    private AbstractHealthDescriptor createHealthDescriptor(String threshold, String healthy, String unHealthy) {
        HealthDescriptor healthDescriptor = (HealthDescriptor)Mockito.mock(HealthDescriptor.class);
        Thresholds thresholds = new Thresholds();
        thresholds.unstableTotalAll = threshold;
        Mockito.when((Object)healthDescriptor.getThresholds()).thenReturn((Object)thresholds);
        Mockito.when((Object)healthDescriptor.getHealthy()).thenReturn((Object)healthy);
        Mockito.when((Object)healthDescriptor.getUnHealthy()).thenReturn((Object)unHealthy);
        return this.createHealthDescriptor(healthDescriptor);
    }

    protected abstract AbstractHealthDescriptor createHealthDescriptor(HealthDescriptor var1);
}

