/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.specialized;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class OneFloatArgNoBlockCallInstr
extends CallInstr {
    private final double flote;

    public OneFloatArgNoBlockCallInstr(CallType callType, Variable result2, String name2, Operand receiver2, Operand[] args2, boolean potentiallyRefined) {
        super(Operation.CALL_1D, callType, result2, name2, receiver2, args2, null, potentiallyRefined);
        assert (args2.length == 1);
        this.flote = ((Float)args2[0]).value;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new OneFloatArgNoBlockCallInstr(this.getCallType(), ii.getRenamedVariable(this.result), this.getName(), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.isPotentiallyRefined());
    }

    public double getFloatArg() {
        return this.flote;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope dynamicScope, IRubyObject self2, Object[] temp) {
        IRubyObject object = (IRubyObject)this.getReceiver().retrieve(context, self2, currScope, dynamicScope, temp);
        return this.getCallSite().call(context, self2, object, this.flote);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.OneFloatArgNoBlockCallInstr(this);
    }
}

