/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.ffi.LastError;
import jnr.ffi.Runtime;
import jnr.posix.CmsgHdr;
import jnr.posix.MsgHdr;
import jnr.posix.POSIX;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"UNIXSocket"}, parent="BasicSocket")
public class RubyUNIXSocket
extends RubyBasicSocket {
    private static ObjectAllocator UNIXSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUNIXSocket(runtime, klass);
        }
    };
    protected static final int F_GETFL = Fcntl.F_GETFL.intValue();
    protected static final int F_SETFL = Fcntl.F_SETFL.intValue();
    protected static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.intValue();

    static void createUNIXSocket(Ruby runtime) {
        RubyClass rb_cUNIXSocket = runtime.defineClass("UNIXSocket", runtime.getClass("BasicSocket"), UNIXSOCKET_ALLOCATOR);
        runtime.getObject().setConstant("UNIXsocket", rb_cUNIXSocket);
        rb_cUNIXSocket.defineAnnotatedMethods(RubyUNIXSocket.class);
    }

    public RubyUNIXSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject recv2, IRubyObject _fileno) {
        Ruby runtime = context.runtime;
        int fileno2 = (int)_fileno.convertToInteger().getLongValue();
        RubyClass klass = (RubyClass)recv2;
        RubyUNIXSocket unixSocket = (RubyUNIXSocket)Helpers.invoke(context, klass, "allocate");
        UnixSocketChannel channel = UnixSocketChannel.fromFD(fileno2);
        unixSocket.init_sock(runtime, channel);
        return unixSocket;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context.runtime, path2, false);
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        return RubyString.newEmptyString(context.runtime);
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        Ruby runtime = context.runtime;
        return runtime.newArray((IRubyObject)runtime.newString("AF_UNIX"), (IRubyObject)RubyString.newEmptyString(runtime));
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        Ruby runtime = context.runtime;
        return runtime.newArray((IRubyObject)runtime.newString("AF_UNIX"), (IRubyObject)runtime.newString(this.openFile.getPath()));
    }

    @JRubyMethod(name={"recvfrom"}, required=1, optional=1)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject _length = args2[0];
        IRubyObject _flags = args2.length == 2 ? args2[1] : runtime.getNil();
        _length = args2[0];
        if (_flags.isNil()) {
            boolean flags2 = false;
        } else {
            int flags3 = RubyNumeric.fix2int(_flags);
        }
        return runtime.newArray(this.recv(context, _length), this.peeraddr(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject send_io(ThreadContext context, IRubyObject arg2) {
        int fd;
        Ruby runtime = context.runtime;
        POSIX posix = runtime.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        if (arg2.callMethod(context, "kind_of?", runtime.getIO()).isTrue()) {
            fd = ((RubyIO)arg2).getOpenFileChecked().getFileno();
        } else if (arg2.callMethod(context, "kind_of?", runtime.getFixnum()).isTrue()) {
            fd = ((RubyFixnum)arg2).getIntValue();
        } else {
            throw runtime.newTypeError("neither IO nor file descriptor");
        }
        if (FilenoUtil.isFake(fd)) {
            throw runtime.newTypeError("file descriptor is not native");
        }
        byte[] dataBytes = new byte[]{0};
        MsgHdr outMessage = posix.allocateMsgHdr();
        ByteBuffer[] outIov = new ByteBuffer[]{ByteBuffer.allocateDirect(dataBytes.length)};
        outIov[0].put(dataBytes);
        outIov[0].flip();
        outMessage.setIov(outIov);
        CmsgHdr outControl = outMessage.allocateControl(4);
        outControl.setLevel(SocketLevel.SOL_SOCKET.intValue());
        outControl.setType(1);
        ByteBuffer fdBuf = ByteBuffer.allocateDirect(4);
        fdBuf.order(ByteOrder.nativeOrder());
        fdBuf.putInt(0, fd);
        outControl.setData(fdBuf);
        boolean locked = fptr.lock();
        try {
            while (posix.sendmsg(fptr.getFileno(), outMessage, 0) == -1) {
                if (fptr.waitWritable(context)) continue;
                throw runtime.newErrnoFromInt(posix.errno(), "sendmsg(2)");
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=2)
    public IRubyObject recv_io(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        POSIX posix = runtime.getPosix();
        OpenFile fptr = this.getOpenFileChecked();
        IRubyObject klass = runtime.getIO();
        IRubyObject mode2 = runtime.getNil();
        if (args2.length > 0) {
            klass = args2[0];
        }
        if (args2.length > 1) {
            mode2 = args2[1];
        }
        MsgHdr inMessage = posix.allocateMsgHdr();
        ByteBuffer[] inIov = new ByteBuffer[]{ByteBuffer.allocateDirect(1)};
        inMessage.setIov(inIov);
        CmsgHdr inControl = inMessage.allocateControl(4);
        inControl.setLevel(SocketLevel.SOL_SOCKET.intValue());
        inControl.setType(1);
        ByteBuffer fdBuf = ByteBuffer.allocateDirect(4);
        fdBuf.order(ByteOrder.nativeOrder());
        fdBuf.putInt(0, -1);
        inControl.setData(fdBuf);
        boolean locked = fptr.lock();
        try {
            while (posix.recvmsg(fptr.getFileno(), inMessage, 0) == -1) {
                if (fptr.waitReadable(context)) continue;
                throw runtime.newErrnoFromInt(posix.errno(), "recvmsg(2)");
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
        ByteBuffer inFdBuf = inMessage.getControls()[0].getData();
        inFdBuf.order(ByteOrder.nativeOrder());
        RubyFixnum fd = runtime.newFixnum(inFdBuf.getInt());
        if (klass.isNil()) {
            return fd;
        }
        if (mode2.isNil()) {
            return Helpers.invoke(context, klass, "for_fd", (IRubyObject)fd);
        }
        return Helpers.invoke(context, klass, "for_fd", (IRubyObject)fd, mode2);
    }

    @JRubyMethod(name={"socketpair", "pair"}, optional=2, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        try {
            UnixSocketChannel[] sp = UnixSocketChannel.pair();
            RubyClass UNIXSocket = runtime.getClass("UNIXSocket");
            RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, UNIXSocket, "allocate");
            sock.init_sock(runtime, sp[0], "");
            RubyUNIXSocket sock2 = (RubyUNIXSocket)Helpers.invoke(context, UNIXSocket, "allocate");
            sock2.init_sock(runtime, sp[1], "");
            return runtime.newArray((IRubyObject)sock, (IRubyObject)sock2);
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    @Override
    public IRubyObject setsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt, IRubyObject val) {
        SocketLevel level2 = RubyUNIXSocket.levelFromArg(_level);
        SocketOption opt = RubyUNIXSocket.optionFromArg(_opt);
        block0 : switch (level2) {
            case SOL_SOCKET: {
                switch (opt) {
                    case SO_KEEPALIVE: {
                        break block0;
                    }
                }
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
            default: {
                throw context.runtime.newErrnoENOPROTOOPTError();
            }
        }
        return context.runtime.newFixnum(0);
    }

    protected static void rb_sys_fail(Ruby runtime, String message2) {
        int n = LastError.getLastError(Runtime.getSystemRuntime());
        RubyClass instance = runtime.getErrno(n);
        if (instance == null) {
            throw runtime.newSystemCallError(message2);
        }
        throw runtime.newErrnoFromInt(n, message2);
    }

    protected void init_unixsock(Ruby runtime, IRubyObject _path, boolean server) {
        ByteList path2 = _path.convertToString().getByteList();
        String fpath = Helpers.decodeByteList(runtime, path2);
        int maxSize = 103;
        if (fpath.length() > 103) {
            throw runtime.newArgumentError("too long unix socket path (max: " + maxSize + "bytes)");
        }
        try {
            if (server) {
                UnixServerSocketChannel channel = UnixServerSocketChannel.open();
                UnixServerSocket socket2 = channel.socket();
                socket2.bind(new UnixSocketAddress(new File(fpath)));
                this.init_sock(runtime, channel, fpath);
            } else {
                File fpathFile = new File(fpath);
                if (!fpathFile.exists()) {
                    throw runtime.newErrnoENOENTError("unix socket");
                }
                UnixSocketChannel channel = UnixSocketChannel.open();
                channel.connect(new UnixSocketAddress(fpathFile));
                this.init_sock(runtime, channel);
            }
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    protected void init_sock(Ruby runtime, Channel channel, String path2) {
        this.MakeOpenFile();
        ModeFlags modes = RubyUNIXSocket.newModeFlags(runtime, ModeFlags.RDWR);
        this.openFile.setFD(RubyUNIXSocket.newChannelFD(runtime, channel));
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setSync(true);
        this.openFile.setPath(path2);
    }

    protected void init_sock(Ruby runtime, Channel channel) {
        this.init_sock(runtime, channel, null);
    }
}

