/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class Frame {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private Block block = Block.NULL_BLOCK;
    private boolean isBindingFrame = false;
    private Visibility visibility = Visibility.PUBLIC;
    private int jumpTarget;

    public Frame() {
    }

    private Frame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.block = frame.block;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        this.jumpTarget = frame.jumpTarget;
    }

    public void updateFrame() {
        this.updateFrame(null, null, null, Block.NULL_BLOCK, 0);
    }

    public void updateFrame(String name2) {
        this.name = name2;
    }

    public void updateFrame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.block = frame.block;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        this.jumpTarget = frame.jumpTarget;
    }

    public void updateFrame(RubyModule klazz, IRubyObject self2, String name2, Block block, int jumpTarget) {
        assert (block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = self2;
        this.name = name2;
        this.klazz = klazz;
        this.block = block;
        this.visibility = Visibility.PUBLIC;
        this.isBindingFrame = false;
        this.jumpTarget = jumpTarget;
    }

    public void updateFrameForEval(IRubyObject self2, int jumpTarget) {
        this.self = self2;
        this.name = null;
        this.visibility = Visibility.PRIVATE;
        this.isBindingFrame = false;
        this.jumpTarget = jumpTarget;
    }

    public void clear() {
        this.self = null;
        this.klazz = null;
        this.block = Block.NULL_BLOCK;
    }

    public Frame duplicate() {
        return new Frame(this);
    }

    public Frame duplicateForBacktrace() {
        Frame backtraceFrame = new Frame();
        backtraceFrame.name = this.name;
        backtraceFrame.isBindingFrame = this.isBindingFrame;
        return backtraceFrame;
    }

    public int getJumpTarget() {
        return this.jumpTarget;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule klazz) {
        this.klazz = klazz;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public String getName() {
        return this.name;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self2) {
        this.self = self2;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isBindingFrame() {
        return this.isBindingFrame;
    }

    public void setIsBindingFrame(boolean isBindingFrame) {
        this.isBindingFrame = isBindingFrame;
    }

    public Block getBlock() {
        return this.block;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.klazz);
        if (this.name != null) {
            sb.append(" in ").append(this.name);
        }
        return sb.toString();
    }
}

