/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.Serializable;
import java.util.Collection;
import org.jruby.ast.CommentNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDESourcePosition
implements ISourcePosition,
Serializable {
    private static final long serialVersionUID = 3762529027281400377L;
    private final String file;
    private final int startLine;
    private final int endLine;
    private int startOffset;
    private final int endOffset;
    private Collection<CommentNode> comments = Node.EMPTY_COMMENT_LIST;

    public IDESourcePosition() {
        this("", 0, 0);
    }

    public IDESourcePosition(String file, int startLine, int endLine) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public IDESourcePosition(String file, int startLine, int endLine, int startOffset, int endOffset) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IDESourcePosition)) {
            return false;
        }
        IDESourcePosition other = (IDESourcePosition)object;
        return this.file.equals(other.file) && this.endLine == other.endLine;
    }

    public int hashCode() {
        return this.file.hashCode() ^ this.endLine;
    }

    public String toString() {
        return this.file + ":[" + this.startLine + "," + this.endLine + "]:[" + this.getStartOffset() + "," + this.getEndOffset() + "]";
    }

    @Override
    public void adjustStartOffset(int relativeValue) {
        this.startOffset += relativeValue;
        if (this.startOffset < 0) {
            this.startOffset = 0;
        }
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public ISourcePosition union(ISourcePosition other) {
        return new IDESourcePosition(this.file, this.startLine, other.getEndLine(), this.startOffset, other.getEndOffset());
    }

    public static IDESourcePosition combinePosition(ISourcePosition firstPos, ISourcePosition secondPos) {
        String fileName = firstPos.getFile();
        int startOffset = firstPos.getStartOffset();
        int endOffset = firstPos.getEndOffset();
        int startLine = firstPos.getStartLine();
        int endLine = firstPos.getEndLine();
        if (startOffset > secondPos.getStartOffset()) {
            startOffset = secondPos.getStartOffset();
            startLine = secondPos.getStartLine();
        }
        if (endOffset < secondPos.getEndOffset()) {
            endOffset = secondPos.getEndOffset();
            endLine = secondPos.getEndLine();
        }
        IDESourcePosition combinedPosition = new IDESourcePosition(fileName, startLine, endLine, startOffset, endOffset);
        return combinedPosition;
    }

    @Override
    public Collection<CommentNode> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(Collection<CommentNode> comments) {
        this.comments = comments;
    }
}

