/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod
extends JavaCallable {
    private final Method method;
    private final Class<?>[] parameterTypes;
    private final JavaUtil.JavaConverter returnConverter;

    public static RubyClass createJavaMethodClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaMethod", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaMethod.class);
        JavaAccessibleObject.registerRubyMethods(runtime, result);
        JavaCallable.registerRubyMethods(runtime, result);
        result.defineFastMethod("name", callbackFactory.getFastMethod("name"));
        result.defineFastMethod("final?", callbackFactory.getFastMethod("final_p"));
        result.defineFastMethod("static?", callbackFactory.getFastMethod("static_p"));
        result.defineFastMethod("bridge?", callbackFactory.getFastMethod("bridge_p"));
        result.defineFastMethod("invoke", callbackFactory.getFastOptMethod("invoke"));
        result.defineFastMethod("invoke_static", callbackFactory.getFastOptMethod("invoke_static"));
        result.defineFastMethod("return_type", callbackFactory.getFastMethod("return_type"));
        result.defineFastMethod("type_parameters", callbackFactory.getFastMethod("type_parameters"));
        return result;
    }

    public JavaMethod(Ruby runtime, Method method) {
        super(runtime, runtime.getJavaSupport().getJavaModule().fastGetClass("JavaMethod"));
        this.method = method;
        this.parameterTypes = method.getParameterTypes();
        if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getClass().getModifiers()) && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            this.accessibleObject().setAccessible(true);
        }
        this.returnConverter = JavaUtil.getJavaConverter(method.getReturnType());
    }

    public static JavaMethod create(Ruby runtime, Method method) {
        return new JavaMethod(runtime, method);
    }

    public static JavaMethod create(Ruby runtime, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            Method method = javaClass.getMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime, method);
        }
        catch (NoSuchMethodException e) {
            throw runtime.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod createDeclared(Ruby runtime, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw runtime.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod getMatchingDeclaredMethod(Ruby runtime, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            block2: for (Method method : javaClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Class<?>[] targetTypes = method.getParameterTypes();
                if (targetTypes.length == 0 && argumentTypes.length == 0) {
                    return JavaMethod.create(runtime, method);
                }
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (i >= targetTypes.length || !targetTypes[i].isAssignableFrom(argumentTypes[i])) continue block2;
                }
                return JavaMethod.create(runtime, method);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaMethod && this.method == ((JavaMethod)other).method;
    }

    @Override
    public int hashCode() {
        return this.method.hashCode();
    }

    @Override
    public RubyString name() {
        return this.getRuntime().newString(this.method.getName());
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.method.getModifiers()));
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.method.getModifiers()));
    }

    public IRubyObject invoke(IRubyObject[] args) {
        JavaProxyClass jpc;
        JavaProxyMethod jpm;
        if (args.length != 1 + this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, 1 + this.getArity());
        }
        IRubyObject invokee = args[0];
        if (!(invokee instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("invokee not a java object");
        }
        Object javaInvokee = ((JavaObject)invokee).getValue();
        Object[] arguments = new Object[args.length - 1];
        this.convertArguments(this.getRuntime(), arguments, args, 1);
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        if (javaInvokee instanceof InternalJavaProxy && !Modifier.isFinal(this.method.getModifiers()) && (jpm = (jpc = ((InternalJavaProxy)javaInvokee).___getProxyClass()).getMethod(this.method.getName(), this.parameterTypes)) != null && jpm.hasSuperImplementation()) {
            return this.invokeWithExceptionHandling(jpm.getSuperMethod(), javaInvokee, arguments);
        }
        return this.invokeWithExceptionHandling(this.method, javaInvokee, arguments);
    }

    public IRubyObject invoke_static(IRubyObject[] args) {
        if (args.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, this.getArity());
        }
        Object[] arguments = new Object[args.length];
        System.arraycopy(args, 0, arguments, 0, arguments.length);
        this.convertArguments(this.getRuntime(), arguments, args, 0);
        return this.invokeWithExceptionHandling(this.method, null, arguments);
    }

    public IRubyObject return_type() {
        Class<?> klass = this.method.getReturnType();
        if (klass.equals(Void.TYPE)) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), klass);
    }

    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.method.getTypeParameters());
    }

    private IRubyObject invokeWithExceptionHandling(Method method, Object javaInvokee, Object[] arguments) {
        try {
            Object result = method.invoke(javaInvokee, arguments);
            return this.returnConverter.convert(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + "; got: " + this.dumpArgTypes(arguments) + "; error: " + iae.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on '" + method.getName() + "': " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
            return this.getRuntime().getNil();
        }
    }

    private String dumpArgTypes(Object[] arguments) {
        StringBuffer str = new StringBuffer("[");
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            if (arguments[i] == null) {
                str.append("null");
                continue;
            }
            str.append(arguments[i].getClass().getName());
        }
        str.append("]");
        return str.toString();
    }

    private void convertArguments(Ruby runtime, Object[] arguments, Object[] args, int from) {
        Class<?>[] types = this.parameterTypes;
        int i = arguments.length;
        while (--i >= 0) {
            arguments[i] = JavaUtil.convertArgument(runtime, args[i + from], types[i]);
        }
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    protected String nameOnInspection() {
        return "#<" + this.getType().toString() + "/" + this.method.getName() + "(";
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(this.isStatic());
    }

    public RubyBoolean bridge_p() {
        return this.getRuntime().newBoolean(this.method.isBridge());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.method.toGenericString();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.method;
    }
}

