/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AssignmentVisitor {
    public static IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block, boolean checkArity) {
        IRubyObject result = null;
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                AssignmentVisitor.attrAssignNode(runtime, context, self, node, value, block);
                break;
            }
            case CALLNODE: {
                AssignmentVisitor.callNode(runtime, context, self, node, value, block);
                break;
            }
            case CLASSVARASGNNODE: {
                AssignmentVisitor.classVarAsgnNode(context, node, value);
                break;
            }
            case CLASSVARDECLNODE: {
                AssignmentVisitor.classVarDeclNode(runtime, context, node, value);
                break;
            }
            case CONSTDECLNODE: {
                AssignmentVisitor.constDeclNode(runtime, context, self, node, value, block);
                break;
            }
            case DASGNNODE: {
                AssignmentVisitor.dasgnNode(context, node, value);
                break;
            }
            case GLOBALASGNNODE: {
                AssignmentVisitor.globalAsgnNode(runtime, node, value);
                break;
            }
            case INSTASGNNODE: {
                AssignmentVisitor.instAsgnNode(self, node, value);
                break;
            }
            case LOCALASGNNODE: {
                AssignmentVisitor.localAsgnNode(context, node, value);
                break;
            }
            case MULTIPLEASGNNODE: {
                result = AssignmentVisitor.multipleAsgnNode(runtime, context, self, node, value, checkArity);
                break;
            }
            default: {
                throw new RuntimeException("Invalid node encountered in interpreter: \"" + node.getClass().getName() + "\", please report this at www.jruby.org");
            }
        }
        return result;
    }

    private static void attrAssignNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block) {
        CallType callType;
        AttrAssignNode iVisited = (AttrAssignNode)node;
        IRubyObject receiver = ASTInterpreter.eval(runtime, context, iVisited.getReceiverNode(), self, block);
        CallType callType2 = callType = receiver == self ? CallType.VARIABLE : CallType.NORMAL;
        if (iVisited.getArgsNode() == null) {
            RuntimeHelpers.invoke(context, receiver, iVisited.getName(), new IRubyObject[]{value}, callType, Block.NULL_BLOCK);
        } else {
            RubyArray args = (RubyArray)ASTInterpreter.eval(runtime, context, iVisited.getArgsNode(), self, block);
            args.append(value);
            RuntimeHelpers.invoke(context, receiver, iVisited.getName(), args.toJavaArray(), callType, Block.NULL_BLOCK);
        }
    }

    private static void callNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block) {
        CallNode iVisited = (CallNode)node;
        IRubyObject receiver = ASTInterpreter.eval(runtime, context, iVisited.getReceiverNode(), self, block);
        if (iVisited.getArgsNode() == null) {
            RuntimeHelpers.invoke(context, receiver, iVisited.getName(), new IRubyObject[]{value}, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray args = (RubyArray)ASTInterpreter.eval(runtime, context, iVisited.getArgsNode(), self, block);
            args.append(value);
            RuntimeHelpers.invoke(context, receiver, iVisited.getName(), args.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
    }

    private static void classVarAsgnNode(ThreadContext context, Node node, IRubyObject value) {
        ClassVarAsgnNode iVisited = (ClassVarAsgnNode)node;
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, context.getRuntime());
        rubyClass.fastSetClassVar(iVisited.getName(), value);
    }

    private static void classVarDeclNode(Ruby runtime, ThreadContext context, Node node, IRubyObject value) {
        ClassVarDeclNode iVisited = (ClassVarDeclNode)node;
        if (runtime.getVerbose().isTrue() && context.getRubyClass().isSingleton()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.DECLARING_SCLASS_VARIABLE, iVisited.getPosition(), "Declaring singleton class variable.", new Object[0]);
        }
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, context.getRuntime());
        rubyClass.fastSetClassVar(iVisited.getName(), value);
    }

    private static void constDeclNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, Block block) {
        IRubyObject module;
        ConstDeclNode iVisited = (ConstDeclNode)node;
        Node constNode = iVisited.getConstNode();
        if (constNode == null) {
            module = context.getCurrentScope().getStaticScope().getModule();
            if (module == null) {
                throw runtime.newTypeError("no class/module to define constant");
            }
        } else {
            module = constNode instanceof Colon2Node ? ASTInterpreter.eval(runtime, context, ((Colon2Node)iVisited.getConstNode()).getLeftNode(), self, block) : runtime.getObject();
        }
        module.fastSetConstant(iVisited.getName(), value);
    }

    private static void dasgnNode(ThreadContext context, Node node, IRubyObject value) {
        DAsgnNode iVisited = (DAsgnNode)node;
        context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
    }

    private static void globalAsgnNode(Ruby runtime, Node node, IRubyObject value) {
        GlobalAsgnNode iVisited = (GlobalAsgnNode)node;
        runtime.getGlobalVariables().set(iVisited.getName(), value);
    }

    private static void instAsgnNode(IRubyObject self, Node node, IRubyObject value) {
        InstAsgnNode iVisited = (InstAsgnNode)node;
        self.getInstanceVariables().fastSetInstanceVariable(iVisited.getName(), value);
    }

    private static void localAsgnNode(ThreadContext context, Node node, IRubyObject value) {
        LocalAsgnNode iVisited = (LocalAsgnNode)node;
        context.getCurrentScope().setValue(iVisited.getIndex(), value, iVisited.getDepth());
    }

    public static IRubyObject multiAssign(Ruby runtime, ThreadContext context, IRubyObject self, MultipleAsgnNode node, RubyArray value, boolean checkArity) {
        int j;
        int valueLen = value.getLength();
        int varLen = node.getHeadNode() == null ? 0 : node.getHeadNode().size();
        for (j = 0; j < valueLen && j < varLen; ++j) {
            Node lNode = node.getHeadNode().get(j);
            AssignmentVisitor.assign(runtime, context, self, lNode, value.eltInternal(j), Block.NULL_BLOCK, checkArity);
        }
        if (checkArity && j < varLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        Node argsNode = node.getArgsNode();
        if (argsNode != null) {
            if (argsNode.nodeId != NodeType.STARNODE) {
                if (varLen < valueLen) {
                    AssignmentVisitor.assign(runtime, context, self, argsNode, value.subseqLight(varLen, valueLen), Block.NULL_BLOCK, checkArity);
                } else {
                    AssignmentVisitor.assign(runtime, context, self, argsNode, RubyArray.newArrayLight(runtime, 0L), Block.NULL_BLOCK, checkArity);
                }
            }
        } else if (checkArity && valueLen < varLen) {
            throw runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        while (j < varLen) {
            AssignmentVisitor.assign(runtime, context, self, node.getHeadNode().get(j++), runtime.getNil(), Block.NULL_BLOCK, checkArity);
        }
        return value;
    }

    private static IRubyObject multipleAsgnNode(Ruby runtime, ThreadContext context, IRubyObject self, Node node, IRubyObject value, boolean check) {
        MultipleAsgnNode iVisited = (MultipleAsgnNode)node;
        if (!(value instanceof RubyArray)) {
            value = ArgsUtil.convertToRubyArray(runtime, value, iVisited.getHeadNode() != null);
        }
        IRubyObject result = AssignmentVisitor.multiAssign(runtime, context, self, iVisited, (RubyArray)value, check);
        return result;
    }
}

