/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private static ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyRange(runtime, klass);
        }
    };
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            marshalStream.registerLinkTarget(range);
            List<Variable<IRubyObject>> attrs = range.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("begin", range.begin));
            attrs.add(new VariableEntry<IRubyObject>("end", range.end));
            attrs.add(new VariableEntry<RubyBoolean>("excl", range.isExclusive ? runtime.getTrue() : runtime.getFalse()));
            marshalStream.dumpVariables(attrs);
        }

        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange range = (RubyRange)type.allocate();
            unmarshalStream.registerLinkTarget(range);
            unmarshalStream.defaultVariablesUnmarshal(range);
            range.begin = range.removeInternalVariable("begin");
            range.end = range.removeInternalVariable("end");
            range.isExclusive = range.removeInternalVariable("excl").isTrue();
            return range;
        }
    };
    private static byte[] DOTDOTDOT = "...".getBytes();
    private static byte[] DOTDOT = "..".getBytes();

    public RubyRange(Ruby runtime, RubyClass impl) {
        super(runtime, impl);
        this.begin = this.end = runtime.getNil();
    }

    public void init(ThreadContext context, IRubyObject aBegin, IRubyObject aEnd, RubyBoolean aIsExclusive) {
        if (!(aBegin instanceof RubyFixnum) || !(aEnd instanceof RubyFixnum)) {
            try {
                IRubyObject result = aBegin.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", aEnd);
                if (result.isNil()) {
                    throw this.getRuntime().newArgumentError("bad value for range");
                }
            }
            catch (RaiseException rExcptn) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = aBegin;
        this.end = aEnd;
        this.isExclusive = aIsExclusive.isTrue();
    }

    protected void copySpecialInstanceVariables(IRubyObject clone) {
        RubyRange range = (RubyRange)clone;
        range.begin = this.begin;
        range.end = this.end;
        range.isExclusive = this.isExclusive;
    }

    public static RubyClass createRangeClass(Ruby runtime) {
        RubyClass result = runtime.defineClass("Range", runtime.getObject(), RANGE_ALLOCATOR);
        runtime.setRange(result);
        result.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyRange;
            }
        };
        result.setMarshal(RANGE_MARSHAL);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyRange.class);
        result.includeModule(runtime.getEnumerable());
        result.defineAnnotatedMethods(RubyRange.class);
        result.dispatcher = callbackFactory.createDispatcher(result);
        return result;
    }

    public long[] getBeginLength(long limit, boolean truncate, boolean isStrict) {
        long beginLong = RubyNumeric.num2long(this.begin);
        long endLong = RubyNumeric.num2long(this.end);
        if (!this.isExclusive) {
            ++endLong;
        }
        if (beginLong < 0L && (beginLong += limit) < 0L) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && beginLong > limit) {
            if (isStrict) {
                throw this.getRuntime().newRangeError(this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && endLong > limit) {
            endLong = limit;
        }
        if (endLong < 0L || !this.isExclusive && endLong == 0L) {
            endLong += limit;
        }
        return new long[]{beginLong, Math.max(endLong - beginLong, 0L)};
    }

    public long[] begLen(long len, int err) {
        long beg = RubyNumeric.num2long(this.begin);
        long end = RubyNumeric.num2long(this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end + " out of range");
                }
                return null;
            }
            if (end > len) {
                end = len;
            }
        }
        if (end < 0L) {
            end += len;
        }
        if (!this.isExclusive) {
            ++end;
        }
        if ((len = end - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    public static RubyRange newRange(Ruby runtime, ThreadContext context, IRubyObject begin, IRubyObject end, boolean isExclusive) {
        RubyRange range = new RubyRange(runtime, runtime.getRange());
        range.init(context, begin, end, isExclusive ? runtime.getTrue() : runtime.getFalse());
        return range;
    }

    @JRubyMethod(name={"initialize"}, required=2, optional=1, frame=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args, Block unusedBlock) {
        if (args.length == 3) {
            this.init(context, args[0], args[1], args[2].isTrue() ? this.getRuntime().getTrue() : this.getRuntime().getFalse());
        } else if (args.length == 2) {
            this.init(context, args[0], args[1], this.getRuntime().getFalse());
        } else {
            throw this.getRuntime().newArgumentError("Wrong arguments. (anObject, anObject, aBoolean = false) expected");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"first", "begin"})
    public IRubyObject first() {
        return this.begin;
    }

    @JRubyMethod(name={"last", "end"})
    public IRubyObject last() {
        return this.end;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        long baseHash = this.isExclusive ? 1 : 0;
        long beginHash = ((RubyFixnum)this.begin.callMethod(context, MethodIndex.HASH, "hash")).getLongValue();
        long endHash = ((RubyFixnum)this.end.callMethod(context, MethodIndex.HASH, "hash")).getLongValue();
        long hash = baseHash;
        hash ^= beginHash << 1;
        hash ^= endHash << 9;
        return this.getRuntime().newFixnum(hash ^= baseHash << 24);
    }

    @JRubyMethod(name={"inspect"}, frame=true)
    public IRubyObject inspect(ThreadContext context, Block block) {
        RubyString str = RubyString.objAsString(context, this.begin.callMethod(context, "inspect")).strDup();
        RubyString str2 = RubyString.objAsString(context, this.end.callMethod(context, "inspect"));
        str.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        str.concat(str2);
        str.infectBy(str2);
        return str;
    }

    @JRubyMethod(name={"to_s"}, frame=true)
    public IRubyObject to_s(ThreadContext context, Block block) {
        RubyString str = RubyString.objAsString(context, this.begin).strDup();
        RubyString str2 = RubyString.objAsString(context, this.end);
        str.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        str.concat(str2);
        str.infectBy(str2);
        return str;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @JRubyMethod(name={"length"}, frame=true)
    public RubyFixnum length(ThreadContext context, Block block) {
        long size = 0L;
        if (this.begin.callMethod(context, MethodIndex.OP_GT, ">", this.end).isTrue()) {
            return this.getRuntime().newFixnum(0L);
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            size = ((RubyNumeric)this.end).getLongValue() - ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++size;
            }
        } else {
            int compareMethod;
            IRubyObject currentObject = this.begin;
            int n = compareMethod = this.isExclusive ? MethodIndex.OP_LT : MethodIndex.OP_LE;
            while (currentObject.callMethod(context, compareMethod, MethodIndex.NAMES.get(compareMethod), this.end).isTrue()) {
                ++size;
                if (currentObject.equals(this.end)) break;
                currentObject = currentObject.callMethod(context, "succ");
            }
        }
        return this.getRuntime().newFixnum(size);
    }

    @JRubyMethod(name={"=="}, required=1, frame=true)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other, Block block) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        boolean result = this.begin.op_equal(context, otherRange.begin).isTrue() && this.end.op_equal(context, otherRange.end).isTrue() && this.isExclusive == otherRange.isExclusive;
        return this.getRuntime().newBoolean(result);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        if (!this.begin.equals(otherRange.begin) || !this.end.equals(otherRange.end) || this.isExclusive != otherRange.isExclusive) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        if (!this.begin.respondsTo("succ")) {
            throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long endLong = ((RubyNumeric)this.end).getLongValue();
            long i = ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++endLong;
            }
            while (i < endLong) {
                block.yield(context, this.getRuntime().newFixnum(i));
                ++i;
            }
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).upto(context, this.end, this.isExclusive, block);
        } else if (this.getRuntime().getNumeric().isInstance(this.begin)) {
            if (!this.isExclusive) {
                this.end = this.end.callMethod(context, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
            }
            while (this.begin.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", this.end).convertToInteger().getLongValue() < 0L) {
                block.yield(context, this.begin);
                this.begin = this.begin.callMethod(context, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
            }
        } else {
            IRubyObject v = this.begin;
            if (this.isExclusive) {
                while (v.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", this.end).convertToInteger().getLongValue() < 0L && !v.equals(this.end)) {
                    block.yield(context, v);
                    v = v.callMethod(context, "succ");
                }
            } else {
                while (v.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", this.end).convertToInteger().getLongValue() <= 0L) {
                    block.yield(context, v);
                    if (!v.equals(this.end)) {
                        v = v.callMethod(context, "succ");
                        continue;
                    }
                    break;
                }
            }
        }
        return this;
    }

    @JRubyMethod(name={"step"}, optional=1, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject[] args, Block block) {
        IRubyObject currentObject = this.begin;
        int compareMethod = this.isExclusive ? MethodIndex.OP_LT : MethodIndex.OP_LE;
        double stepSize = 1.0;
        if (args.length != 0) {
            stepSize = Double.parseDouble(args[0].toString());
        }
        if (stepSize == 0.0) {
            throw this.getRuntime().newArgumentError("step can't be 0");
        }
        if (stepSize < 0.0) {
            throw this.getRuntime().newArgumentError("step can't be negative");
        }
        if (this.begin instanceof RubyFloat && this.end instanceof RubyFloat) {
            RubyFloat stepNum = this.getRuntime().newFloat(stepSize);
            while (currentObject.callMethod(context, compareMethod, MethodIndex.NAMES.get(compareMethod), this.end).isTrue()) {
                block.yield(context, currentObject);
                currentObject = currentObject.callMethod(context, MethodIndex.OP_PLUS, "+", stepNum);
            }
        } else if (this.begin instanceof RubyNumeric && this.end instanceof RubyNumeric) {
            if ((stepSize = Math.floor(stepSize)) == 0.0) {
                throw this.getRuntime().newArgumentError("step can't be 0");
            }
            RubyFixnum stepNum = this.getRuntime().newFixnum(Double.valueOf(stepSize).longValue());
            while (currentObject.callMethod(context, compareMethod, MethodIndex.NAMES.get(compareMethod), this.end).isTrue()) {
                block.yield(context, currentObject);
                currentObject = currentObject.callMethod(context, MethodIndex.OP_PLUS, "+", stepNum);
            }
        } else if (this.begin instanceof RubyString && this.end instanceof RubyString) {
            boolean pastEnd;
            RubyString afterEnd = this.isExclusive ? (RubyString)this.end : (RubyString)this.end.callMethod(context, "succ");
            boolean bl = pastEnd = this.isExclusive && currentObject.callMethod(context, MethodIndex.EQUALEQUAL, "==", this.end).isTrue();
            block2: while (!pastEnd) {
                block.yield(context, currentObject);
                int i = 0;
                while ((double)i < stepSize) {
                    if ((currentObject = currentObject.callMethod(context, "succ")).callMethod(context, MethodIndex.EQUALEQUAL, "==", afterEnd).isTrue()) {
                        pastEnd = true;
                        continue block2;
                    }
                    ++i;
                }
            }
        } else {
            if (!this.begin.respondsTo("succ")) {
                throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
            }
            while (currentObject.callMethod(context, compareMethod, MethodIndex.NAMES.get(compareMethod), this.end).isTrue()) {
                block.yield(context, currentObject);
                int i = 0;
                while ((double)i < stepSize) {
                    currentObject = currentObject.callMethod(context, "succ");
                    ++i;
                }
            }
        }
        return this;
    }

    private boolean r_lt(ThreadContext context, IRubyObject a, IRubyObject b) {
        IRubyObject r = a.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", b);
        if (r.isNil()) {
            return false;
        }
        return RubyComparable.cmpint(context, r, a, b) < 0;
    }

    private boolean r_le(ThreadContext context, IRubyObject a, IRubyObject b) {
        IRubyObject r = a.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", b);
        if (r.isNil()) {
            return false;
        }
        return RubyComparable.cmpint(context, r, a, b) <= 0;
    }

    @JRubyMethod(name={"include?", "member?", "==="}, required=1, frame=true)
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj, Block block) {
        RubyBoolean val = this.getRuntime().getFalse();
        if (this.r_le(context, this.begin, obj)) {
            if (this.isExclusive) {
                if (this.r_lt(context, obj, this.end)) {
                    val = this.getRuntime().getTrue();
                }
            } else if (this.r_le(context, obj, this.end)) {
                val = this.getRuntime().getTrue();
            }
        }
        return val;
    }
}

