/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2020-2025 The JReleaser authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jreleaser.gradle.plugin.dsl.distributions

import groovy.transform.CompileStatic
import org.gradle.api.Action
import org.gradle.api.provider.ListProperty
import org.gradle.api.provider.Property
import org.jreleaser.gradle.plugin.dsl.common.Activatable
import org.jreleaser.gradle.plugin.dsl.common.Artifact
import org.jreleaser.gradle.plugin.dsl.common.Executable
import org.jreleaser.gradle.plugin.dsl.common.ExtraProperties
import org.jreleaser.gradle.plugin.dsl.common.Java
import org.jreleaser.gradle.plugin.dsl.common.Matrix
import org.jreleaser.gradle.plugin.dsl.packagers.Packagers
import org.jreleaser.gradle.plugin.dsl.platform.Platform
import org.jreleaser.model.Distribution.DistributionType
import org.jreleaser.model.Stereotype

/**
 *
 * @author Andres Almiray
 * @since 0.1.0
 */
@CompileStatic
interface Distribution extends Activatable, ExtraProperties, Packagers {
    Property<DistributionType> getDistributionType()

    Property<Stereotype> getStereotype()

    ListProperty<String> getTags()

    void setDistributionType(String str)

    void tag(String tag)

    Java getJava()

    Platform getPlatform()

    Executable getExecutable()

    void setStereotype(String str)

    Property<Boolean> getApplyDefaultMatrix()

    void matrix(Action<? super Matrix> action)

    void artifact(Action<? super Artifact> action)

    void artifactPattern(Action<? super Artifact> action)

    void java(Action<? super Java> action)

    void platform(Action<? super Platform> action)

    void executable(Action<? super Executable> action)
}