/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.gradle.plugin.tasks;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.options.Option;
import org.jreleaser.engine.context.ContextCreator;
import org.jreleaser.gradle.plugin.JReleaserExtension;
import org.jreleaser.gradle.plugin.internal.JReleaserLoggerService;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.util.Env;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class AbstractJReleaserTask
extends DefaultTask
implements GroovyObject {
    @Input
    private final Property<Boolean> dryrun;
    @Input
    private final Property<Boolean> gitRootSearch;
    @Input
    private final Property<Boolean> strict;
    @InputDirectory
    private final DirectoryProperty outputDirectory;
    @org.gradle.api.tasks.Internal
    private final Property<JReleaserModel> model;
    @org.gradle.api.tasks.Internal
    private final Property<JReleaserLoggerService> jlogger;
    @org.gradle.api.tasks.Internal
    private JReleaserContext.Mode mode;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Inject
    public AbstractJReleaserTask(ObjectFactory objects) {
        DirectoryProperty directoryProperty;
        Property property;
        Property property2;
        Property property3;
        JReleaserContext.Mode mode;
        Property property4;
        Property property5;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.model = property5 = objects.property(JReleaserModel.class);
        this.jlogger = property4 = objects.property(JReleaserLoggerService.class);
        this.mode = mode = JReleaserContext.Mode.FULL;
        this.dryrun = property3 = objects.property(Boolean.class);
        this.gitRootSearch = property2 = objects.property(Boolean.class);
        this.strict = property = objects.property(Boolean.class);
        this.outputDirectory = directoryProperty = objects.directoryProperty();
    }

    @Option(description="Skip remote operations (OPTIONAL).", option="dryrun")
    public void setDryrun(boolean dryrun) {
        this.dryrun.set((Object)dryrun);
    }

    @Option(description="Searches for the Git root (OPTIONAL).", option="git-root-search")
    public void setGitRootSearch(boolean gitRootSearch) {
        this.gitRootSearch.set((Object)gitRootSearch);
    }

    @Option(description="Enable strict mode (OPTIONAL).", option="strict")
    public void setStrict(boolean strict) {
        this.strict.set((Object)strict);
    }

    protected JReleaserContext createContext() {
        JReleaserLogger logger = ((JReleaserLoggerService)this.jlogger.get()).getLogger();
        PlatformUtils.resolveCurrentPlatform((JReleaserLogger)logger);
        logger.info("JReleaser {}", new Object[]{JReleaserVersion.getPlainVersion()});
        JReleaserVersion.banner((PrintWriter)logger.getTracer());
        logger.increaseIndent();
        logger.info("- basedir set to {}", new Object[]{this.getProject().getProjectDir().toPath().toAbsolutePath()});
        logger.info("- outputdir set to {}", new Object[]{((Directory)this.outputDirectory.get()).getAsFile().toPath().toAbsolutePath()});
        logger.decreaseIndent();
        return ContextCreator.create((JReleaserLogger)logger, (JReleaserContext.Configurer)this.resolveConfigurer((JReleaserExtension)ScriptBytecodeAdapter.castToType((Object)this.getProject().getExtensions().findByType(JReleaserExtension.class), JReleaserExtension.class)), (JReleaserContext.Mode)this.mode, (JReleaserModel)((JReleaserModel)ScriptBytecodeAdapter.castToType((Object)this.model.get(), JReleaserModel.class)), (Path)this.getProject().getProjectDir().toPath(), (Path)((Directory)this.outputDirectory.get()).getAsFile().toPath(), (boolean)DefaultTypeTransformation.booleanUnbox((Object)this.dryrun.getOrElse((Object)false)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)this.gitRootSearch.getOrElse((Object)false)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)this.strict.getOrElse((Object)false)), this.collectSelectedPlatforms(), this.collectRejectedPlatforms());
    }

    protected boolean resolveBoolean(String key, Boolean value) {
        if (value != null) {
            return DefaultTypeTransformation.booleanUnbox((Object)value);
        }
        String resolvedValue = Env.resolve((String)key, (String)"");
        return StringUtils.isNotBlank((String)resolvedValue) && Boolean.parseBoolean(resolvedValue);
    }

    protected List<String> resolveCollection(String key, List<String> values) {
        if (!values.isEmpty()) {
            return values;
        }
        String resolvedValue = Env.resolve((String)key, (String)"");
        if (StringUtils.isBlank((String)resolvedValue)) {
            return Collections.emptyList();
        }
        public final class _resolveCollection_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveCollection_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object s) {
                return ((String)s).trim();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveCollection_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _resolveCollection_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveCollection_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object s) {
                return StringUtils.isNotBlank((String)ShortTypeHandling.castToString((Object)s));
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveCollection_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (List)ScriptBytecodeAdapter.castToType(Arrays.stream((Object[])ScriptBytecodeAdapter.castToType((Object)resolvedValue.trim().split(","), Object[].class)).map((Function)ScriptBytecodeAdapter.castToType((Object)((Object)new _resolveCollection_closure1((Object)this, (Object)this)), Function.class)).filter((Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new _resolveCollection_closure2((Object)this, (Object)this)), Predicate.class)).collect(Collectors.toList()), List.class);
    }

    protected List<String> collectSelectedPlatforms() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    protected List<String> collectRejectedPlatforms() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    protected JReleaserContext.Configurer resolveConfigurer(JReleaserExtension extension) {
        if (!extension.getConfigFile().isPresent()) {
            return JReleaserContext.Configurer.GRADLE;
        }
        File configFile = ((RegularFile)extension.getConfigFile().get()).getAsFile();
        String string = StringUtils.getFilenameExtension((String)configFile.getName());
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"yml") || ScriptBytecodeAdapter.isCase((Object)string, (Object)"yaml")) {
            return JReleaserContext.Configurer.CLI_YAML;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"toml")) {
            return JReleaserContext.Configurer.CLI_TOML;
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"json")) {
            return JReleaserContext.Configurer.CLI_JSON;
        }
        throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Invalid configuration format: ", (CharSequence)configFile.getName()));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AbstractJReleaserTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final Property<Boolean> getDryrun() {
        return this.dryrun;
    }

    @Generated
    public final Property<Boolean> getGitRootSearch() {
        return this.gitRootSearch;
    }

    @Generated
    public final Property<Boolean> getStrict() {
        return this.strict;
    }

    @Generated
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public final Property<JReleaserModel> getModel() {
        return this.model;
    }

    @Generated
    public final Property<JReleaserLoggerService> getJlogger() {
        return this.jlogger;
    }

    @Generated
    public JReleaserContext.Mode getMode() {
        return this.mode;
    }

    @Generated
    public void setMode(JReleaserContext.Mode mode) {
        this.mode = mode;
    }
}

