/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.gradle.plugin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jreleaser.gradle.plugin.internal.JReleaserLoggerAdapter;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.util.IoUtils;
import org.kordamp.gradle.util.AnsiConsole;

public abstract class JReleaserLoggerService
implements BuildService<Params>,
AutoCloseable {
    private final JReleaserLogger logger;

    public JReleaserLoggerService() {
        try {
            Path outputDirectoryPath = ((Directory)((Params)this.getParameters()).getOutputDirectory().get()).getAsFile().toPath();
            Files.createDirectories(outputDirectoryPath, new FileAttribute[0]);
            File traceLogFile = outputDirectoryPath.resolve("trace.log").toFile();
            PrintWriter tracer = IoUtils.newPrintWriter((OutputStream)new FileOutputStream(traceLogFile));
            this.logger = new JReleaserLoggerAdapter((AnsiConsole)((Params)this.getParameters()).getConsole().get(), (LogLevel)((Params)this.getParameters()).getLogLevel().get(), tracer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public JReleaserLogger getLogger() {
        return this.logger;
    }

    @Override
    public void close() {
        this.logger.close();
    }

    public static interface Params
    extends BuildServiceParameters {
        public Property<AnsiConsole> getConsole();

        public Property<LogLevel> getLogLevel();

        public DirectoryProperty getOutputDirectory();
    }
}

