/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.gradle.plugin.internal;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.LogLevel;
import org.jreleaser.logging.AbstractJReleaserLogger;
import org.jreleaser.util.IoUtils;
import org.kordamp.gradle.util.AnsiConsole;
import org.slf4j.helpers.MessageFormatter;

public class JReleaserLoggerAdapter
extends AbstractJReleaserLogger
implements GroovyObject {
    private final PrintWriter out;
    private final Level level;
    private final AnsiConsole console;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public JReleaserLoggerAdapter(AnsiConsole console, LogLevel logLevel, PrintWriter tracer) {
        this(console, logLevel, tracer, IoUtils.newPrintWriter((OutputStream)System.out));
    }

    public JReleaserLoggerAdapter(AnsiConsole console, LogLevel logLevel, PrintWriter tracer, PrintWriter out) {
        super(tracer);
        AnsiConsole ansiConsole;
        Level level;
        PrintWriter printWriter;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.out = printWriter = out;
        this.level = level = JReleaserLoggerAdapter.resolveLogLevel(logLevel);
        this.console = ansiConsole = console;
    }

    public void plain(String message) {
        String msg = this.formatMessage(message);
        this.out.println(msg);
        this.trace(msg);
    }

    public void debug(String message) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.log(Level.DEBUG, message);
        }
        this.trace(Level.DEBUG, message);
    }

    public void info(String message) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.log(Level.INFO, message);
        }
        this.trace(Level.INFO, message);
    }

    public void warn(String message) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.log(Level.WARN, message);
        }
        this.trace(Level.WARN, message);
    }

    public void error(String message) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.log(Level.ERROR, message);
        }
        this.trace(Level.ERROR, message);
    }

    public void plain(String message, Object ... args) {
        this.plain(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
    }

    public void debug(String message, Object ... args) {
        String msg = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.log(Level.DEBUG, msg);
        }
        this.trace(Level.DEBUG, msg);
    }

    public void info(String message, Object ... args) {
        String msg = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        if (this.isLevelEnabled(Level.INFO)) {
            this.log(Level.INFO, msg);
        }
        this.trace(Level.INFO, msg);
    }

    public void warn(String message, Object ... args) {
        String msg = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        if (this.isLevelEnabled(Level.WARN)) {
            this.log(Level.WARN, msg);
        }
        this.trace(Level.WARN, msg);
    }

    public void error(String message, Object ... args) {
        String msg = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        if (this.isLevelEnabled(Level.ERROR)) {
            this.log(Level.ERROR, msg);
        }
        this.trace(Level.ERROR, msg);
    }

    public void plain(String message, Throwable throwable) {
        String msg = this.formatMessage(message);
        this.out.println(msg);
        if (DefaultTypeTransformation.booleanUnbox((Object)throwable)) {
            throwable.printStackTrace(this.out);
        }
        this.trace(msg, throwable);
    }

    public void debug(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.log(Level.DEBUG, message, throwable);
        }
        this.trace(Level.DEBUG, message, throwable);
    }

    public void info(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.log(Level.INFO, message, throwable);
        }
        this.trace(Level.INFO, message, throwable);
    }

    public void warn(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.log(Level.WARN, message, throwable);
        }
        this.trace(Level.WARN, message, throwable);
    }

    public void error(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.log(Level.ERROR, message, throwable);
        }
        this.trace(Level.ERROR, message, throwable);
    }

    private void log(Level level, String message) {
        this.log(level, message, null);
    }

    private void log(Level level, String message, Throwable throwable) {
        StringBuilder b = new StringBuilder("[");
        if (this.console.getPlain()) {
            b.append(level.name());
        } else {
            String string = level.color();
            if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"cyan")) {
                b.append(this.console.cyan((CharSequence)level.name()));
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"blue")) {
                b.append(this.console.blue((CharSequence)level.name()));
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"yellow")) {
                b.append(this.console.yellow((CharSequence)level.name()));
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"red")) {
                b.append(this.console.red((CharSequence)level.name()));
            }
        }
        DefaultGroovyMethods.println((PrintWriter)this.out, (Object)b.append("] ").append(level.name().length() == 4 ? " " : "").append(this.formatMessage(message)));
        if (DefaultTypeTransformation.booleanUnbox((Object)throwable)) {
            this.printThrowable(throwable);
        }
    }

    private void trace(Level level, String message) {
        this.trace(level, message, null);
    }

    private void trace(Level level, String message, Throwable throwable) {
        StringBuilder b = new StringBuilder("[").append(level.name()).append("] ").append(level.name().length() == 4 ? " " : "").append(this.formatMessage(message));
        if (DefaultTypeTransformation.booleanUnbox((Object)throwable)) {
            this.trace(b.toString(), throwable);
        } else {
            this.trace(b.toString());
        }
    }

    private void printThrowable(Throwable throwable) {
        if (throwable != null) {
            throwable.printStackTrace(this.console.getPlain() ? this.out : new Colorizer(this, this.out));
        }
    }

    private boolean isLevelEnabled(Level requested) {
        return requested.ordinal() >= this.level.ordinal();
    }

    private static Level resolveLogLevel(LogLevel logLevel) {
        LogLevel logLevel2 = logLevel;
        if (ScriptBytecodeAdapter.isCase((Object)logLevel2, (Object)LogLevel.DEBUG)) {
            return Level.DEBUG;
        }
        if (ScriptBytecodeAdapter.isCase((Object)logLevel2, (Object)LogLevel.WARN)) {
            return Level.WARN;
        }
        if (ScriptBytecodeAdapter.isCase((Object)logLevel2, (Object)LogLevel.ERROR)) {
            return Level.ERROR;
        }
        if (ScriptBytecodeAdapter.isCase((Object)logLevel2, (Object)LogLevel.QUIET)) {
            return Level.QUIET;
        }
        if (ScriptBytecodeAdapter.isCase((Object)logLevel2, (Object)LogLevel.INFO)) {
            // empty if block
        }
        return Level.INFO;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JReleaserLoggerAdapter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(JReleaserLoggerAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(JReleaserLoggerAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(JReleaserLoggerAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, JReleaserLoggerAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(JReleaserLoggerAdapter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private class Colorizer
    extends PrintWriter
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        final /* synthetic */ JReleaserLoggerAdapter this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Colorizer(JReleaserLoggerAdapter $p$, PrintWriter delegate) {
            MetaClass metaClass;
            JReleaserLoggerAdapter jReleaserLoggerAdapter;
            this.this$0 = jReleaserLoggerAdapter = $p$;
            super((Writer)delegate, true);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public void print(String s) {
            super.print(this.this$0.console.red((CharSequence)s));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Colorizer.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$2(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(Colorizer.class, JReleaserLoggerAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(Colorizer.class, JReleaserLoggerAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(Colorizer.class, JReleaserLoggerAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            this.this$0.this$dist$set$2(name, value);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, JReleaserLoggerAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$2(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Colorizer.class, JReleaserLoggerAdapter.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }

    public static final class Level
    extends Enum<Level>
    implements GroovyObject {
        public static final /* enum */ Level DEBUG;
        public static final /* enum */ Level INFO;
        public static final /* enum */ Level WARN;
        public static final /* enum */ Level ERROR;
        public static final /* enum */ Level QUIET;
        private final String color;
        public static final Level MIN_VALUE;
        public static final Level MAX_VALUE;
        private static final /* synthetic */ Level[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        private Level(String color) {
            String string;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.color = string = color;
        }

        public String color() {
            return this.color;
        }

        @Generated
        public static final Level[] values() {
            return (Level[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Level[].class);
        }

        @Generated
        public Level next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                ordinal = 0;
            }
            return (Level)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Level.class);
        }

        @Generated
        public Level previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                ordinal = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (Level)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Level.class);
        }

        @Generated
        public static Level valueOf(String name) {
            return (Level)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Level.class, name)), Level.class);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Generated
        public static final /* synthetic */ Level $INIT(Object ... para) {
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Level.class)) {
                case -613992018: {
                    return new Level(ShortTypeHandling.castToString((Object)objectArray[2]));
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
        }

        static {
            Level level;
            Level level2;
            Level level3;
            Level level4;
            Level level5;
            Level level6;
            Level level7;
            DEBUG = level7 = Level.$INIT("DEBUG", 0, "cyan");
            INFO = level6 = Level.$INIT("INFO", 1, "blue");
            WARN = level5 = Level.$INIT("WARN", 2, "yellow");
            ERROR = level4 = Level.$INIT("ERROR", 3, "red");
            QUIET = level3 = Level.$INIT("QUIET", 4, "black");
            MIN_VALUE = level2 = DEBUG;
            MAX_VALUE = level = QUIET;
            Level[] levelArray = new Level[]{DEBUG, INFO, WARN, ERROR, QUIET};
            $VALUES = levelArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Level.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

