/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.gradle.api.Project;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class Banner
implements BuildService<Params> {
    private static final String ORG_JRELEASER_BANNER = "org.jreleaser.banner";
    private String productVersion;
    private String productId;
    private final List<String> projectNames = new ArrayList<String>();

    public void display(Project project) {
        if (this.checkIfVisited(project)) {
            return;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(Banner.class.getName());
        this.productVersion = bundle.getString("product.version");
        this.productId = bundle.getString("product.id");
        String productName = bundle.getString("product.name");
        String banner = MessageFormat.format(bundle.getString("product.banner"), productName, this.productVersion);
        boolean printBanner = null == System.getProperty(ORG_JRELEASER_BANNER) || Boolean.getBoolean(ORG_JRELEASER_BANNER);
        File parent = new File(project.getGradle().getGradleUserHomeDir(), "caches");
        File markerFile = this.getMarkerFile(parent);
        if (!markerFile.exists()) {
            if (printBanner) {
                System.err.println(banner);
            }
            markerFile.getParentFile().mkdirs();
            Banner.writeQuietly(markerFile, "1");
        } else {
            try {
                int count = Integer.parseInt(Banner.readQuietly(markerFile));
                if (count < 3 && printBanner) {
                    System.err.println(banner);
                }
                Banner.writeQuietly(markerFile, count + 1 + "");
            }
            catch (NumberFormatException e) {
                if (printBanner) {
                    System.err.println(banner);
                }
                Banner.writeQuietly(markerFile, "1");
            }
        }
    }

    private boolean checkIfVisited(Project project) {
        if (this.projectNames.contains(project.getRootProject().getName())) {
            return true;
        }
        this.projectNames.add(project.getRootProject().getName());
        return false;
    }

    private File getMarkerFile(File parent) {
        return new File(parent, "jreleaser" + File.separator + this.productId + File.separator + this.productVersion + File.separator + "marker.txt");
    }

    private static void writeQuietly(File file, String text) {
        try {
            PrintStream out = Banner.newPrintStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            out.println(text);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readQuietly(File file) {
        Scanner in = Banner.newScanner(Files.newInputStream(file.toPath(), new OpenOption[0]));
        try {
            String string = in.next();
            if (in != null) {
                in.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ignored) {
                return "";
            }
        }
    }

    private static Scanner newScanner(InputStream in) {
        return new Scanner(in, StandardCharsets.UTF_8.name());
    }

    private static PrintStream newPrintStream(OutputStream out) {
        return Banner.newPrintStream(out, true);
    }

    private static PrintStream newPrintStream(OutputStream out, boolean autoFlush) {
        try {
            return new PrintStream(out, autoFlush, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static interface Params
    extends BuildServiceParameters {
    }
}

