/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring.backend;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.util.ClassUtil;
import org.jolokia.server.core.util.JsonUtil;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.service.jmx.handler.list.DataKeys;
import org.jolokia.support.spring.backend.SpringCommandHandler;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringListHandler
extends SpringCommandHandler<JolokiaListRequest> {
    private static final String NAME_PREFIX = "name=";
    private static final Map<Class<?>, String> WRAPPER_TO_PRIMITIVE = new HashMap();

    public SpringListHandler(ApplicationContext pAppContext, JolokiaContext pJolokiaContext) {
        super(pAppContext, pJolokiaContext, RequestType.LIST);
    }

    @Override
    public Object handleRequest(JolokiaListRequest pJmxReq, Object pPreviousResult) {
        String providerAndDomain;
        BeanDefinition requestedBean;
        String domain = this.getApplicationContext().getApplicationName();
        if (domain.isEmpty()) {
            domain = "default";
        }
        if ((requestedBean = this.beanFromRequest(pJmxReq, providerAndDomain = "spring@" + domain)) != null) {
            return this.getSpringBeanInfo(requestedBean);
        }
        JSONObject ret = new JSONObject();
        JSONObject beans = this.getAllSpringBeans(this.getAsConfigurableApplicationContext());
        ret.put((Object)providerAndDomain, (Object)beans);
        return ret;
    }

    private BeanDefinition beanFromRequest(JolokiaListRequest pJmxReq, String providerAndDomain) {
        String beanAndName;
        List pathParts = pJmxReq.getPathParts();
        if (pathParts != null && pathParts.size() == 2 && providerAndDomain.equals(pathParts.get(0)) && (beanAndName = (String)pathParts.get(1)).toLowerCase().startsWith(NAME_PREFIX)) {
            String beanName = beanAndName.substring(NAME_PREFIX.length());
            return this.getAsConfigurableApplicationContext().getBeanFactory().getMergedBeanDefinition(beanName);
        }
        return null;
    }

    private JSONObject getAllSpringBeans(ConfigurableApplicationContext appCtx) {
        ConfigurableListableBeanFactory bdFactory = appCtx.getBeanFactory();
        JSONObject ret = new JSONObject();
        for (String beanName : appCtx.getBeanDefinitionNames()) {
            BeanDefinition bd = bdFactory.getMergedBeanDefinition(beanName);
            if (bd.isAbstract()) continue;
            ret.put((Object)(NAME_PREFIX + beanName), (Object)this.getSpringBeanInfo(bd));
        }
        return ret;
    }

    private JSONObject getSpringBeanInfo(BeanDefinition pBeanDef) {
        Class beanClass;
        JSONObject ret = new JSONObject();
        ret.put((Object)DataKeys.DESCRIPTION.getKey(), (Object)pBeanDef.getDescription());
        String beanClassName = pBeanDef.getBeanClassName();
        if (beanClassName != null && (beanClass = ClassUtil.classForName((String)beanClassName, (ClassLoader[])new ClassLoader[0])) != null) {
            ret.put((Object)DataKeys.ATTRIBUTES.getKey(), (Object)this.getAttributes(pBeanDef, beanClass));
            ret.put((Object)DataKeys.OPERATIONS.getKey(), (Object)this.getOperations(beanClass));
        }
        return ret;
    }

    private JSONObject getOperations(Class<?> pBeanClass) {
        JSONObject ret = new JSONObject();
        for (Method method : pBeanClass.getMethods()) {
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier) || (modifier & 0x408) != 0) continue;
            JSONObject oMap = new JSONObject();
            oMap.put((Object)DataKeys.ARGS.getKey(), (Object)this.extractArguments(method));
            oMap.put((Object)DataKeys.RETURN_TYPE.getKey(), (Object)this.classToString(method.getReturnType()));
            JsonUtil.addJSONObjectToJSONObject((JSONObject)ret, (String)method.getName(), (JSONObject)oMap);
        }
        return ret;
    }

    private JSONArray extractArguments(Method method) {
        JSONArray ret = new JSONArray(method.getParameterTypes().length);
        int i = 0;
        for (Class<?> paramType : method.getParameterTypes()) {
            JSONObject params = new JSONObject();
            params.put((Object)DataKeys.TYPE.getKey(), (Object)this.classToString(paramType));
            params.put((Object)NAME_PREFIX, (Object)("arg" + i++));
            ret.add((Object)params);
        }
        return ret;
    }

    private JSONObject getAttributes(BeanDefinition pBeanDef, Class<?> pBeanClass) {
        JSONObject ret = new JSONObject();
        this.addIfNotNull(ret, DataKeys.DESCRIPTION, pBeanDef.getDescription());
        for (PropertyDescriptor propDesc : BeanUtils.getPropertyDescriptors(pBeanClass)) {
            JSONObject aMap = new JSONObject();
            Class<?> propType = propDesc.getPropertyType();
            this.addIfNotNull(aMap, DataKeys.TYPE, propType != null ? this.classToString(propType) : null);
            this.addIfNotNull(aMap, DataKeys.DESCRIPTION, propDesc.getShortDescription());
            aMap.put((Object)DataKeys.READ_WRITE.getKey(), (Object)(propDesc.getWriteMethod() != null ? 1 : 0));
            ret.put((Object)propDesc.getName(), (Object)aMap);
        }
        return ret;
    }

    private ConfigurableApplicationContext getAsConfigurableApplicationContext() {
        ApplicationContext appCtx = this.getApplicationContext();
        if (!(appCtx instanceof ConfigurableApplicationContext)) {
            throw new IllegalArgumentException("Given Spring application context " + String.valueOf(appCtx) + " is not a ConfigurableApplicationContext");
        }
        return (ConfigurableApplicationContext)appCtx;
    }

    private void addIfNotNull(JSONObject pMap, DataKeys pKey, String pValue) {
        if (pValue != null) {
            pMap.put((Object)pKey.getKey(), (Object)pValue);
        }
    }

    private String classToString(Class<?> pClass) {
        if (pClass.isPrimitive()) {
            String ret = WRAPPER_TO_PRIMITIVE.get(pClass);
            if (ret == null) {
                throw new IllegalStateException("Internal: No mapping for primitive type " + String.valueOf(pClass) + " found");
            }
            return ret;
        }
        return pClass.getCanonicalName();
    }

    static {
        Object[] p = new Object[]{Boolean.TYPE, "boolean", Character.TYPE, "character", Byte.TYPE, "byte", Short.TYPE, "short", Integer.TYPE, "int", Long.TYPE, "long", Float.TYPE, "float", Double.TYPE, "double", Void.TYPE, "void"};
        for (int i = 0; i < p.length; i += 2) {
            WRAPPER_TO_PRIMITIVE.put((Class)p[i], (String)p[i + 1]);
        }
    }
}

