/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client;

import java.lang.reflect.InvocationTargetException;
import org.jolokia.jvmagent.client.command.CommandDispatcher;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.PlatformUtils;
import org.jolokia.jvmagent.client.util.ProcessingException;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;

public final class AgentLauncher {
    private AgentLauncher() {
    }

    public static void main(String ... args) {
        try {
            int exitCode;
            OptionsAndArgs options = new OptionsAndArgs(CommandDispatcher.getAvailableCommands(), args);
            VirtualMachineHandlerOperations vmHandler = PlatformUtils.createVMAccess(options);
            CommandDispatcher dispatcher = new CommandDispatcher(options);
            Object vm = options.needsVm() ? vmHandler.attachVirtualMachine() : null;
            try {
                exitCode = dispatcher.dispatchCommand(vm, vmHandler);
            }
            catch (InvocationTargetException e) {
                throw new ProcessingException("InvocationTargetException", e, options);
            }
            catch (NoSuchMethodException e) {
                throw new ProcessingException("Internal: NoSuchMethod", e, options);
            }
            catch (IllegalAccessException e) {
                throw new ProcessingException("IllegalAccess", e, options);
            }
            finally {
                if (vm != null) {
                    vmHandler.detachAgent(vm);
                }
            }
            System.exit(exitCode);
        }
        catch (IllegalArgumentException exp) {
            System.err.println("Error: " + exp.getMessage() + "\n");
            CommandDispatcher.printHelp();
            System.exit(1);
        }
        catch (ProcessingException exp) {
            exp.printErrorMessage();
            System.exit(1);
        }
    }
}

