/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import jodd.http.Buffer;
import jodd.http.Cookie;
import jodd.http.HttpBase;
import jodd.http.HttpConnection;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpException;
import jodd.http.HttpMultiMap;
import jodd.http.HttpProgressListener;
import jodd.http.HttpResponse;
import jodd.http.HttpUtil;
import jodd.http.JoddHttp;
import jodd.util.Base64;
import jodd.util.StringBand;
import jodd.util.StringUtil;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private static final int DEFAULT_PORT = -1;
    protected String protocol = "http";
    protected String host = "localhost";
    protected int port = -1;
    protected String method = "GET";
    protected String path = "/";
    protected HttpMultiMap<String> query;
    protected String queryEncoding = JoddHttp.defaultQueryEncoding;
    protected int timeout = -1;
    protected HttpConnection httpConnection;
    protected HttpConnectionProvider httpConnectionProvider;

    public HttpRequest() {
        this.initRequest();
    }

    protected void initRequest() {
        this.connectionKeepAlive(false);
    }

    public String host() {
        return this.host;
    }

    public HttpRequest host(String host) {
        this.host = host;
        return this;
    }

    public String protocol() {
        return this.protocol;
    }

    public HttpRequest protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public int port() {
        if (this.port == -1) {
            if (this.protocol == null) {
                return 80;
            }
            if (this.protocol.equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return this.port;
    }

    public HttpRequest port(int port) {
        this.port = port;
        return this;
    }

    public HttpRequest set(String destination) {
        int ndx = (destination = destination.trim()).indexOf(32);
        if (ndx != -1) {
            this.method = destination.substring(0, ndx).toUpperCase();
            destination = destination.substring(ndx + 1);
        }
        if ((ndx = destination.indexOf("://")) != -1) {
            this.protocol = destination.substring(0, ndx);
            destination = destination.substring(ndx + 3);
        }
        if ((ndx = destination.indexOf(47)) == -1) {
            ndx = destination.length();
        }
        if (ndx != 0) {
            this.host = destination.substring(0, ndx);
            destination = destination.substring(ndx);
            ndx = this.host.indexOf(58);
            if (ndx == -1) {
                this.port = -1;
            } else {
                this.port = Integer.parseInt(this.host.substring(ndx + 1));
                this.host = this.host.substring(0, ndx);
            }
        }
        this.path(destination);
        return this;
    }

    public static HttpRequest connect(String destination) {
        return new HttpRequest().method("CONNECT").set(destination);
    }

    public static HttpRequest get(String destination) {
        return new HttpRequest().method("GET").set(destination);
    }

    public static HttpRequest post(String destination) {
        return new HttpRequest().method("POST").set(destination);
    }

    public static HttpRequest put(String destination) {
        return new HttpRequest().method("PUT").set(destination);
    }

    public static HttpRequest patch(String destination) {
        return new HttpRequest().method("PATCH").set(destination);
    }

    public static HttpRequest delete(String destination) {
        return new HttpRequest().method("DELETE").set(destination);
    }

    public static HttpRequest head(String destination) {
        return new HttpRequest().method("HEAD").set(destination);
    }

    public static HttpRequest trace(String destination) {
        return new HttpRequest().method("TRACE").set(destination);
    }

    public static HttpRequest options(String destination) {
        return new HttpRequest().method("OPTIONS").set(destination);
    }

    public String method() {
        return this.method;
    }

    public HttpRequest method(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public String path() {
        return this.path;
    }

    public HttpRequest path(String path) {
        int ndx;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((ndx = path.indexOf(63)) != -1) {
            String queryString = path.substring(ndx + 1);
            path = path.substring(0, ndx);
            this.query = HttpUtil.parseQuery(queryString, true);
        } else {
            this.query = HttpMultiMap.newCaseInsensitveMap();
        }
        this.path = path;
        return this;
    }

    public HttpRequest multipart(boolean multipart) {
        this.multipart = true;
        return this;
    }

    public HttpRequest cookies(Cookie ... cookies) {
        if (cookies.length == 0) {
            return this;
        }
        StringBuilder cookieString = new StringBuilder();
        boolean first = true;
        for (Cookie cookie : cookies) {
            Integer maxAge = cookie.getMaxAge();
            if (maxAge != null && maxAge == 0) continue;
            if (!first) {
                cookieString.append("; ");
            }
            first = false;
            cookieString.append(cookie.getName());
            cookieString.append('=');
            cookieString.append(cookie.getValue());
        }
        this.header("cookie", cookieString.toString(), true);
        return this;
    }

    public HttpRequest query(String name, String value) {
        this.query.add(name, value);
        return this;
    }

    public HttpRequest query(String name1, Object value1, Object ... parameters) {
        this.query(name1, value1 == null ? null : value1.toString());
        for (int i = 0; i < parameters.length; i += 2) {
            String name = parameters[i].toString();
            String value = parameters[i + 1].toString();
            this.query.add(name, value == null ? null : value);
        }
        return this;
    }

    public HttpRequest query(Map<String, String> queryMap) {
        for (Map.Entry<String, String> entry : queryMap.entrySet()) {
            this.query.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpMultiMap<String> query() {
        return this.query;
    }

    public HttpRequest clearQueries() {
        this.query.clear();
        return this;
    }

    public HttpRequest removeQuery(String name) {
        this.query.remove(name);
        return this;
    }

    public HttpRequest queryString(String queryString) {
        return this.queryString(queryString, true);
    }

    public HttpRequest queryString(String queryString, boolean decode) {
        this.query = HttpUtil.parseQuery(queryString, decode);
        return this;
    }

    public String queryString() {
        if (this.query == null) {
            return "";
        }
        return HttpUtil.buildQuery(this.query, this.queryEncoding);
    }

    public HttpRequest queryEncoding(String encoding) {
        this.queryEncoding = encoding;
        return this;
    }

    public String url() {
        String queryString;
        StringBuilder url = new StringBuilder();
        url.append(this.hostUrl());
        if (this.path != null) {
            url.append(this.path);
        }
        if (StringUtil.isNotBlank((String)(queryString = this.queryString()))) {
            url.append('?');
            url.append(queryString);
        }
        return url.toString();
    }

    public String hostUrl() {
        StringBand url = new StringBand(8);
        if (this.protocol != null) {
            url.append(this.protocol);
            url.append("://");
        }
        if (this.host != null) {
            url.append(this.host);
        }
        if (this.port != -1) {
            url.append(':');
            url.append(this.port);
        }
        return url.toString();
    }

    public HttpRequest basicAuthentication(String username, String password) {
        String data = username.concat(":").concat(password);
        String base64 = Base64.encodeToString((String)data);
        this.header("Authorization", "Basic " + base64, true);
        return this;
    }

    public HttpRequest setHostHeader() {
        String hostPort = this.host;
        if (this.port != -1) {
            hostPort = hostPort + ":" + this.port;
        }
        this.header("Host", hostPort, true);
        return this;
    }

    public HttpRequest monitor(HttpProgressListener httpProgressListener) {
        this.httpProgressListener = httpProgressListener;
        return this;
    }

    public HttpRequest timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public int timeout() {
        return this.timeout;
    }

    public HttpConnectionProvider httpConnectionProvider() {
        return this.httpConnectionProvider;
    }

    public HttpConnection httpConnection() {
        return this.httpConnection;
    }

    public HttpRequest open() {
        return this.open(JoddHttp.httpConnectionProvider);
    }

    public HttpRequest open(HttpConnectionProvider httpConnectionProvider) {
        if (this.httpConnection != null) {
            throw new HttpException("Connection already opened");
        }
        try {
            this.httpConnectionProvider = httpConnectionProvider;
            this.httpConnection = httpConnectionProvider.createHttpConnection(this);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        return this;
    }

    public HttpRequest open(HttpConnection httpConnection) {
        if (this.httpConnection != null) {
            throw new HttpException("Connection already opened");
        }
        this.httpConnection = httpConnection;
        this.httpConnectionProvider = null;
        return this;
    }

    public HttpRequest keepAlive(HttpResponse httpResponse, boolean doContinue) {
        boolean keepAlive = httpResponse.isConnectionPersistent();
        if (keepAlive) {
            HttpConnection previousConnection = httpResponse.getHttpRequest().httpConnection;
            if (previousConnection != null) {
                this.httpConnection = previousConnection;
                this.httpConnectionProvider = httpResponse.getHttpRequest().httpConnectionProvider();
            }
        } else {
            httpResponse.close();
            keepAlive = true;
        }
        if (!doContinue) {
            keepAlive = false;
        }
        this.connectionKeepAlive(keepAlive);
        if (this.httpConnection == null) {
            this.open(httpResponse.getHttpRequest().httpConnectionProvider());
        }
        return this;
    }

    public HttpResponse send() {
        HttpResponse httpResponse;
        if (this.httpConnection == null) {
            this.open();
        }
        try {
            OutputStream outputStream = this.httpConnection.getOutputStream();
            this.sendTo(outputStream);
            InputStream inputStream = this.httpConnection.getInputStream();
            httpResponse = HttpResponse.readFrom(inputStream);
            httpResponse.assignHttpRequest(this);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        boolean keepAlive = httpResponse.isConnectionPersistent();
        if (!keepAlive) {
            this.httpConnection.close();
            this.httpConnection = null;
        }
        return httpResponse;
    }

    @Override
    protected Buffer buffer(boolean fullRequest) {
        if (this.header("Host") == null) {
            this.setHostHeader();
        }
        Buffer formBuffer = this.formBuffer();
        String queryString = this.queryString();
        if (this.header("User-Agent") == null) {
            this.header("User-Agent", "Jodd HTTP");
        }
        if (this.method.equals("POST") && this.contentLength() == null) {
            this.contentLength(0);
        }
        Buffer request = new Buffer();
        request.append(this.method).append(" ").append(this.path);
        if (this.query != null && !this.query.isEmpty()) {
            request.append('?');
            request.append(queryString);
        }
        request.append(" ").append(this.httpVersion).append("\r\n");
        for (String key : this.headers.names()) {
            List values = this.headers.getAll(key);
            String headerName = HttpUtil.prepareHeaderParameterName(key);
            for (String value : values) {
                request.append(headerName);
                request.append(": ");
                request.append(value);
                request.append("\r\n");
            }
        }
        if (fullRequest) {
            request.append("\r\n");
            if (this.form != null) {
                request.append(formBuffer);
            } else if (this.body != null) {
                request.append(this.body);
            }
        }
        return request;
    }

    public static HttpRequest readFrom(InputStream in) {
        String line;
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException uneex) {
            return null;
        }
        HttpRequest httpRequest = new HttpRequest();
        try {
            line = reader.readLine();
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        if (!StringUtil.isBlank((CharSequence)line)) {
            String[] s = StringUtil.splitc((String)line, (char)' ');
            httpRequest.method(s[0]);
            httpRequest.path(s[1]);
            httpRequest.httpVersion(s[2]);
            httpRequest.readHeaders(reader);
            httpRequest.readBody(reader);
        }
        return httpRequest;
    }
}

