/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jodd.http.Cookie;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpMultiMap;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.JoddHttp;
import jodd.http.ProxyInfo;

public class HttpBrowser {
    protected HttpConnectionProvider httpConnectionProvider;
    protected HttpRequest httpRequest;
    protected HttpResponse httpResponse;
    protected HttpMultiMap<Cookie> cookies = HttpMultiMap.newCaseInsensitveMap();
    protected HttpMultiMap<String> defaultHeaders = HttpMultiMap.newCaseInsensitveMap();
    protected boolean keepAlive;
    protected long elapsedTime;

    public HttpBrowser() {
        this.httpConnectionProvider = JoddHttp.httpConnectionProvider;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpBrowser setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public HttpBrowser setProxyInfo(ProxyInfo proxyInfo) {
        this.httpConnectionProvider.useProxy(proxyInfo);
        return this;
    }

    public HttpBrowser setHttpConnectionProvider(HttpConnectionProvider httpConnectionProvider) {
        this.httpConnectionProvider = httpConnectionProvider;
        return this;
    }

    public HttpBrowser setDefaultHeader(String name, String value) {
        this.defaultHeaders.add(name, value);
        return this;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getPage() {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.bodyText();
    }

    public HttpResponse sendRequest(HttpRequest httpRequest) {
        this.elapsedTime = System.currentTimeMillis();
        while (true) {
            String newPath;
            this.httpRequest = httpRequest;
            HttpResponse previouseResponse = this.httpResponse;
            this.httpResponse = null;
            this.addDefaultHeaders(httpRequest);
            this.addCookies(httpRequest);
            if (!this.keepAlive) {
                httpRequest.open(this.httpConnectionProvider);
            } else if (previouseResponse == null) {
                httpRequest.open(this.httpConnectionProvider).connectionKeepAlive(true);
            } else {
                httpRequest.keepAlive(previouseResponse, true);
            }
            this.httpResponse = httpRequest.send();
            this.readCookies(this.httpResponse);
            int statusCode = this.httpResponse.statusCode();
            if (statusCode == 301) {
                newPath = this.location(this.httpResponse);
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode == 302 || statusCode == 303) {
                newPath = this.location(this.httpResponse);
                httpRequest = HttpRequest.get(newPath);
                continue;
            }
            if (statusCode != 307) break;
            newPath = this.location(this.httpResponse);
            String originalMethod = httpRequest.method();
            httpRequest = new HttpRequest().method(originalMethod).set(newPath);
        }
        this.elapsedTime = System.currentTimeMillis() - this.elapsedTime;
        return this.httpResponse;
    }

    protected void addDefaultHeaders(HttpRequest httpRequest) {
        List<Map.Entry<String, String>> entries = this.defaultHeaders.entries();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            if (httpRequest.headers.contains(name)) continue;
            httpRequest.headers.add(name, entry.getValue());
        }
    }

    protected String location(HttpResponse httpResponse) {
        String location = httpResponse.header("location");
        if (location.startsWith("/")) {
            HttpRequest httpRequest = httpResponse.getHttpRequest();
            location = httpRequest.hostUrl() + location;
        }
        return location;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void close() {
        if (this.httpResponse != null) {
            this.httpResponse.close();
        }
    }

    protected void readCookies(HttpResponse httpResponse) {
        Cookie[] newCookies;
        for (Cookie cookie : newCookies = httpResponse.cookies()) {
            this.cookies.add(cookie.getName(), cookie);
        }
    }

    protected void addCookies(HttpRequest httpRequest) {
        ArrayList<Cookie> cookiesList = new ArrayList<Cookie>();
        if (!this.cookies.isEmpty()) {
            for (Map.Entry<String, Cookie> entry : this.cookies) {
                cookiesList.add(entry.getValue());
            }
            httpRequest.cookies(cookiesList.toArray(new Cookie[cookiesList.size()]));
        }
    }
}

