/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import mockit.coverage.CallPoint;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerFileLineCoverage
implements PerFileCoverage {
    private static final long serialVersionUID = 6318915843739466316L;
    private static final int[] NO_EXECUTIONS_YET = new int[0];
    @NotNull
    private final Map<Integer, LineCoverageData> lineToLineData = new HashMap<Integer, LineCoverageData>(128);
    @NotNull
    private int[] executionCounts = NO_EXECUTIONS_YET;
    @NotNull
    private transient LineCoverageData sharedLineData = new LineCoverageData();
    private int lastLine;
    private transient int totalSegments;
    private transient int coveredSegments;

    public PerFileLineCoverage() {
        this.initializeCache();
    }

    private void initializeCache() {
        this.coveredSegments = -1;
        this.totalSegments = -1;
    }

    private void readObject(@NotNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.sharedLineData = new LineCoverageData();
        this.initializeCache();
        in.defaultReadObject();
        if (this.executionCounts.length == 0) {
            this.executionCounts = NO_EXECUTIONS_YET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLine(int line) {
        if (!this.lineToLineData.containsKey(line)) {
            this.lineToLineData.put(line, null);
        }
        if (line > this.lastLine) {
            if (this.executionCounts != NO_EXECUTIONS_YET && line >= this.executionCounts.length) {
                Map<Integer, LineCoverageData> map = this.lineToLineData;
                synchronized (map) {
                    int[] newCounts = new int[line + 30];
                    System.arraycopy(this.executionCounts, 0, newCounts, 0, this.executionCounts.length);
                    this.executionCounts = newCounts;
                }
            }
            this.lastLine = line;
        }
    }

    @NotNull
    public LineCoverageData getOrCreateLineData(int line) {
        LineCoverageData lineData = this.lineToLineData.get(line);
        if (lineData == null) {
            lineData = new LineCoverageData();
            this.lineToLineData.put(line, lineData);
        }
        return lineData;
    }

    @NotNull
    public BranchCoverageData getBranchData(int line, int index) {
        LineCoverageData lineData = this.lineToLineData.get(line);
        return lineData.getBranchData(index);
    }

    public int getBranchCount(int line) {
        LineCoverageData lineData = this.lineToLineData.get(line);
        return lineData == null ? 0 : lineData.getBranches().size();
    }

    public boolean acceptsAdditionalCallPoints(int line) {
        LineCoverageData lineData = this.getOrCreateLineData(line);
        return lineData.acceptsAdditionalCallPoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExecution(int line, @Nullable CallPoint callPoint) {
        if (this.executionCounts == NO_EXECUTIONS_YET) {
            this.executionCounts = new int[this.lastLine + 1];
        }
        Map<Integer, LineCoverageData> map = this.lineToLineData;
        synchronized (map) {
            int n = line;
            this.executionCounts[n] = this.executionCounts[n] + 1;
        }
        if (callPoint != null) {
            LineCoverageData lineData = this.getOrCreateLineData(line);
            lineData.registerExecution(callPoint);
        }
    }

    public boolean acceptsAdditionalCallPoints(int line, int branchIndex) {
        LineCoverageData lineData = this.getOrCreateLineData(line);
        return lineData.acceptsAdditionalCallPoints(branchIndex);
    }

    public void registerExecution(int line, int branchIndex, @Nullable CallPoint callPoint) {
        LineCoverageData lineData = this.getOrCreateLineData(line);
        lineData.registerExecution(branchIndex, callPoint);
    }

    public int getLineCount() {
        return this.lastLine;
    }

    public int getExecutableLineCount() {
        return this.lineToLineData.size();
    }

    public boolean hasLineData(int line) {
        return this.executionCounts != NO_EXECUTIONS_YET && this.lineToLineData.containsKey(line);
    }

    @NotNull
    public LineCoverageData getLineData(int line) {
        LineCoverageData data = this.lineToLineData.get(line);
        if (data == null) {
            data = this.sharedLineData;
        }
        data.setExecutionCount(this.executionCounts[line]);
        return data;
    }

    public int getExecutionCount(int line) {
        return line < this.executionCounts.length ? this.executionCounts[line] : -1;
    }

    @Override
    public int getTotalItems() {
        this.computeValuesIfNeeded();
        return this.totalSegments;
    }

    @Override
    public int getCoveredItems() {
        this.computeValuesIfNeeded();
        return this.coveredSegments;
    }

    @Override
    public int getCoveragePercentage() {
        this.computeValuesIfNeeded();
        return CoveragePercentage.calculate(this.coveredSegments, this.totalSegments);
    }

    private void computeValuesIfNeeded() {
        if (this.totalSegments >= 0) {
            return;
        }
        this.coveredSegments = 0;
        this.totalSegments = 0;
        int n = this.lastLine;
        for (int line = 1; line <= n; ++line) {
            if (!this.lineToLineData.containsKey(line)) continue;
            LineCoverageData lineData = this.lineToLineData.get(line);
            if (lineData == null) {
                ++this.totalSegments;
                if (this.executionCounts == NO_EXECUTIONS_YET || this.executionCounts[line] <= 0) continue;
                ++this.coveredSegments;
                continue;
            }
            this.totalSegments += lineData.getNumberOfSegments();
            this.coveredSegments += lineData.getNumberOfCoveredSegments();
        }
    }

    public int getNumberOfSegments(int line) {
        if (!this.lineToLineData.containsKey(line)) {
            return 0;
        }
        LineCoverageData lineData = this.lineToLineData.get(line);
        return lineData == null ? 1 : lineData.getNumberOfSegments();
    }

    public void reset() {
        for (int i = 1; i < this.executionCounts.length; ++i) {
            this.executionCounts[i] = 0;
        }
        for (LineCoverageData lineData : this.lineToLineData.values()) {
            if (lineData == null) continue;
            lineData.reset();
        }
        this.initializeCache();
    }

    public void mergeInformation(@NotNull PerFileLineCoverage previousCoverage) {
        LineCoverageData previousLineInfo;
        Integer line;
        Map<Integer, LineCoverageData> previousInfo = previousCoverage.lineToLineData;
        boolean previousRunHadLinesExecuted = previousCoverage.executionCounts.length > 0;
        for (Map.Entry<Integer, LineCoverageData> lineAndInfo : this.lineToLineData.entrySet()) {
            line = lineAndInfo.getKey();
            previousLineInfo = previousInfo.get(line);
            if (previousLineInfo == null) continue;
            LineCoverageData lineInfo = lineAndInfo.getValue();
            if (lineInfo == null) {
                lineInfo = new LineCoverageData();
                lineAndInfo.setValue(lineInfo);
            }
            lineInfo.addCountsFromPreviousTestRun(previousLineInfo);
            if (!previousRunHadLinesExecuted) continue;
            this.createExecutionCountsArrayIfNeeded(previousCoverage);
            int n = line;
            this.executionCounts[n] = this.executionCounts[n] + previousCoverage.executionCounts[line];
        }
        for (Map.Entry<Integer, LineCoverageData> lineAndInfo : previousInfo.entrySet()) {
            line = lineAndInfo.getKey();
            if (this.lineToLineData.containsKey(line)) continue;
            previousLineInfo = lineAndInfo.getValue();
            this.lineToLineData.put(line, previousLineInfo);
            if (!previousRunHadLinesExecuted) continue;
            this.createExecutionCountsArrayIfNeeded(previousCoverage);
            this.executionCounts[line.intValue()] = previousCoverage.executionCounts[line];
        }
    }

    private void createExecutionCountsArrayIfNeeded(@NotNull PerFileLineCoverage previousCoverage) {
        if (this.executionCounts == NO_EXECUTIONS_YET) {
            this.executionCounts = new int[previousCoverage.executionCounts.length];
        }
    }
}

