/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.dataItems;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.dataItems.FieldData;
import mockit.coverage.dataItems.InstanceFieldData;
import mockit.coverage.dataItems.StaticFieldData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerFileDataCoverage
implements PerFileCoverage {
    private static final long serialVersionUID = -4561686103982673490L;
    @NotNull
    public final List<String> allFields = new ArrayList<String>(2);
    @NotNull
    public final Map<String, StaticFieldData> staticFieldsData = new LinkedHashMap<String, StaticFieldData>();
    @NotNull
    public final Map<String, InstanceFieldData> instanceFieldsData = new LinkedHashMap<String, InstanceFieldData>();
    private transient int coveredDataItems = -1;

    private void readObject(@NotNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.coveredDataItems = -1;
        in.defaultReadObject();
    }

    public void addField(@NotNull String className, @NotNull String fieldName, boolean isStatic) {
        String classAndField = className + '.' + fieldName;
        this.allFields.add(classAndField);
        if (isStatic) {
            this.staticFieldsData.put(classAndField, new StaticFieldData());
        } else {
            this.instanceFieldsData.put(classAndField, new InstanceFieldData());
        }
    }

    public boolean isFieldWithCoverageData(@NotNull String classAndFieldNames) {
        return this.instanceFieldsData.containsKey(classAndFieldNames) || this.staticFieldsData.containsKey(classAndFieldNames);
    }

    public synchronized void registerAssignmentToStaticField(@NotNull String classAndFieldNames) {
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        if (staticData != null) {
            staticData.registerAssignment();
        }
    }

    @Nullable
    public StaticFieldData getStaticFieldData(@NotNull String classAndFieldNames) {
        return this.staticFieldsData.get(classAndFieldNames);
    }

    public synchronized void registerReadOfStaticField(@NotNull String classAndFieldNames) {
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        if (staticData != null) {
            staticData.registerRead();
        }
    }

    public synchronized void registerAssignmentToInstanceField(@NotNull Object instance, @NotNull String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        if (instanceData != null) {
            instanceData.registerAssignment(instance);
        }
    }

    @Nullable
    public InstanceFieldData getInstanceFieldData(@NotNull String classAndFieldNames) {
        return this.instanceFieldsData.get(classAndFieldNames);
    }

    public synchronized void registerReadOfInstanceField(@NotNull Object instance, @NotNull String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        if (instanceData != null) {
            instanceData.registerRead(instance);
        }
    }

    public boolean hasFields() {
        return !this.allFields.isEmpty();
    }

    public boolean isCovered(@NotNull String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        if (instanceData != null && instanceData.isCovered()) {
            return true;
        }
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        return staticData != null && staticData.isCovered();
    }

    @Override
    public int getTotalItems() {
        return this.staticFieldsData.size() + this.instanceFieldsData.size();
    }

    @Override
    public int getCoveredItems() {
        if (this.coveredDataItems >= 0) {
            return this.coveredDataItems;
        }
        this.coveredDataItems = 0;
        for (StaticFieldData staticData : this.staticFieldsData.values()) {
            if (!staticData.isCovered()) continue;
            ++this.coveredDataItems;
        }
        for (InstanceFieldData instanceData : this.instanceFieldsData.values()) {
            if (!instanceData.isCovered()) continue;
            ++this.coveredDataItems;
        }
        return this.coveredDataItems;
    }

    @Override
    public int getCoveragePercentage() {
        int totalFields = this.getTotalItems();
        if (totalFields == 0) {
            return -1;
        }
        return CoveragePercentage.calculate(this.getCoveredItems(), totalFields);
    }

    public void mergeInformation(@NotNull PerFileDataCoverage previousInfo) {
        this.addInfoFromPreviousTestRun(this.staticFieldsData, previousInfo.staticFieldsData);
        this.addFieldsFromPreviousTestRunIfAbsent(this.staticFieldsData, previousInfo.staticFieldsData);
        this.addInfoFromPreviousTestRun(this.instanceFieldsData, previousInfo.instanceFieldsData);
        this.addFieldsFromPreviousTestRunIfAbsent(this.instanceFieldsData, previousInfo.instanceFieldsData);
    }

    private <FI extends FieldData> void addInfoFromPreviousTestRun(@NotNull Map<String, FI> currentInfo, @NotNull Map<String, FI> previousInfo) {
        for (Map.Entry<String, FI> nameAndInfo : currentInfo.entrySet()) {
            String fieldName = nameAndInfo.getKey();
            FieldData previousFieldInfo = (FieldData)previousInfo.get(fieldName);
            if (previousFieldInfo == null) continue;
            FieldData fieldInfo = (FieldData)nameAndInfo.getValue();
            fieldInfo.addCountsFromPreviousTestRun(previousFieldInfo);
        }
    }

    private <FI extends FieldData> void addFieldsFromPreviousTestRunIfAbsent(@NotNull Map<String, FI> currentInfo, @NotNull Map<String, FI> previousInfo) {
        for (Map.Entry<String, FI> nameAndInfo : previousInfo.entrySet()) {
            String fieldName = nameAndInfo.getKey();
            if (currentInfo.containsKey(fieldName)) continue;
            currentInfo.put(fieldName, previousInfo.get(fieldName));
        }
    }
}

