/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import mockit.coverage.data.CoverageData;
import org.jetbrains.annotations.NotNull;

final class AccretionFile {
    @NotNull
    private final File outputFile;
    @NotNull
    private final CoverageData newData;

    AccretionFile(@NotNull String outputDir, @NotNull CoverageData newData) {
        String parentDir = outputDir.isEmpty() ? null : outputDir;
        this.outputFile = new File(parentDir, "coverage.ser");
        newData.fillLastModifiedTimesForAllClassFiles();
        this.newData = newData;
    }

    void mergeDataFromExistingFileIfAny() throws IOException {
        if (this.outputFile.exists()) {
            CoverageData previousData = CoverageData.readDataFromFile(this.outputFile);
            this.newData.merge(previousData);
        }
    }

    void generate() throws IOException {
        this.newData.writeDataToFile(this.outputFile);
        System.out.println("JMockit: Coverage data written to " + this.outputFile.getCanonicalPath());
    }
}

