package org.jfrog.metadata.client.rest;

import org.jfrog.metadata.client.model.MetadataPackage;
import org.jfrog.metadata.client.model.MetadataFieldRecordingProxy;

import javax.annotation.Nonnull;
import java.lang.reflect.Proxy;

/**
 * @author Uriah Levy
 */
public class MetadataPackageProxyFactory {

    private MetadataPackageProxyFactory() {
    }

    @Nonnull
    public static MetadataPackage create(MetadataPackage entity) {
        return (MetadataPackage) Proxy.newProxyInstance(MetadataPackage.class.getClassLoader(),
                new Class[]{MetadataPackage.class},
                new MetadataFieldRecordingProxy(entity));
    }
}
