package org.jfrog.metadata.client.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Uriah Levy
 */
@EqualsAndHashCode
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MetadataFile implements MetadataEntity {
    private String name;
    private String sha1;
    private String sha256;
    private String md5;
    private long length;
    private String arch;
    private String dist;
    private String mimeType;
    private List<MetadataQualifierEntity> qualifiers;
    private boolean lead;
}
