/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import java.time.LocalDate;
import javax.validation.constraints.Min;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class SupportBundleParameters {
    private boolean configuration = true;
    private boolean system = true;
    private Logs logs = new Logs();
    private ThreadDump threadDump = new ThreadDump();

    public boolean isConfiguration() {
        return this.configuration;
    }

    public boolean isSystem() {
        return this.system;
    }

    public Logs getLogs() {
        return this.logs;
    }

    public ThreadDump getThreadDump() {
        return this.threadDump;
    }

    public void setConfiguration(boolean configuration) {
        this.configuration = configuration;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public void setLogs(Logs logs) {
        this.logs = logs;
    }

    public void setThreadDump(ThreadDump threadDump) {
        this.threadDump = threadDump;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupportBundleParameters)) {
            return false;
        }
        SupportBundleParameters other = (SupportBundleParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isConfiguration() != other.isConfiguration()) {
            return false;
        }
        if (this.isSystem() != other.isSystem()) {
            return false;
        }
        Logs this$logs = this.getLogs();
        Logs other$logs = other.getLogs();
        if (this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs)) {
            return false;
        }
        ThreadDump this$threadDump = this.getThreadDump();
        ThreadDump other$threadDump = other.getThreadDump();
        return !(this$threadDump == null ? other$threadDump != null : !((Object)this$threadDump).equals(other$threadDump));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SupportBundleParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isConfiguration() ? 79 : 97);
        result = result * 59 + (this.isSystem() ? 79 : 97);
        Logs $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        ThreadDump $threadDump = this.getThreadDump();
        result = result * 59 + ($threadDump == null ? 43 : ((Object)$threadDump).hashCode());
        return result;
    }

    public String toString() {
        return "SupportBundleParameters(configuration=" + this.isConfiguration() + ", system=" + this.isSystem() + ", logs=" + this.getLogs() + ", threadDump=" + this.getThreadDump() + ")";
    }

    public SupportBundleParameters() {
    }

    public SupportBundleParameters(boolean configuration, boolean system, Logs logs, ThreadDump threadDump) {
        this.configuration = configuration;
        this.system = system;
        this.logs = logs;
        this.threadDump = threadDump;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class ThreadDump {
        @Min(value=0L)
        private int count = 1;
        @Min(value=0L)
        private long interval = 0L;

        public int getCount() {
            return this.count;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadDump)) {
                return false;
            }
            ThreadDump other = (ThreadDump)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            return this.getInterval() == other.getInterval();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadDump;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            long $interval = this.getInterval();
            result = result * 59 + (int)($interval >>> 32 ^ $interval);
            return result;
        }

        public String toString() {
            return "SupportBundleParameters.ThreadDump(count=" + this.getCount() + ", interval=" + this.getInterval() + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class Logs {
        private boolean include = true;
        @JsonSerialize(using=ToStringSerializer.class)
        @JsonDeserialize(using=LocalDateDeserializer.class)
        private LocalDate startDate = LocalDate.now().minusDays(1L);
        @JsonSerialize(using=ToStringSerializer.class)
        @JsonDeserialize(using=LocalDateDeserializer.class)
        private LocalDate endDate = LocalDate.now();

        public boolean isInclude() {
            return this.include;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public void setStartDate(LocalDate startDate) {
            this.startDate = startDate;
        }

        public void setEndDate(LocalDate endDate) {
            this.endDate = endDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Logs)) {
                return false;
            }
            Logs other = (Logs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isInclude() != other.isInclude()) {
                return false;
            }
            LocalDate this$startDate = this.getStartDate();
            LocalDate other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                return false;
            }
            LocalDate this$endDate = this.getEndDate();
            LocalDate other$endDate = other.getEndDate();
            return !(this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Logs;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isInclude() ? 79 : 97);
            LocalDate $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            LocalDate $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            return result;
        }

        public String toString() {
            return "SupportBundleParameters.Logs(include=" + this.isInclude() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ")";
        }
    }
}

