package org.jfrog.support.rest.model.manifest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jfrog.support.rest.model.BundleCreationStatus;
import org.jfrog.support.rest.model.SupportBundleConfig;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ServiceManifest {
    private String serviceType;
    private String serviceId;
    private Map<String, Map<String, BundleCreationStatus>> microservices;
    private SupportBundleConfig bundleInfo;
    private BundleCreationStatus status;

    @JsonIgnore
    public BundleCreationStatus getMicroservicesAggregatedStatus() {
        if (microservices == null) {
            return BundleCreationStatus.IN_PROGRESS;
        }
        return microservices.values().stream()
                .flatMap(map -> map.values().stream())
                .max(Comparator.comparing(ServiceManifest::getSeverity))
                .orElse(BundleCreationStatus.IN_PROGRESS);
    }

    private static int getSeverity(BundleCreationStatus status) {
        switch (Objects.requireNonNull(status)) {
            case SUCCESS:
                return 0;
            case IN_PROGRESS:
                return 1;
            default:
                return 2;
        }
    }
}
