/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.rest.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jfrog.support.rest.model.manifest.NodeManifest;

import java.util.Map;

/**
 * @author orid
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SupportBundleGenerationResult {

    private Integer statusCode;
    private BundleCreationStatus result;
    private NodeManifest nodeManifest;
    private Map<String, Map<String, String>> microServices;

    public String getNodeId() {
        return nodeManifest == null ? "" : nodeManifest.getNodeId();
    }
}
