/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import java.time.LocalDate;

/**
 * @author Tamir Hadad
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class SupportBundleParameters {
  // Note: do not use Lombok Builder and Builder.Default annotations
  // as they mess up default values during JSON deserialization
  private boolean configuration = true;
  private boolean system = true;
  private Logs logs = new Logs();
  private ThreadDump threadDump = new ThreadDump();

  @Data
  @JsonIgnoreProperties(ignoreUnknown = true)
  @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
  public static class Logs {
    private boolean include = true;
      @JsonSerialize(using = ToStringSerializer.class)
      @JsonDeserialize(using = LocalDateDeserializer.class)
      private LocalDate startDate = LocalDate.now().minusDays(1);
      @JsonSerialize(using = ToStringSerializer.class)
      @JsonDeserialize(using = LocalDateDeserializer.class)
      private LocalDate endDate = LocalDate.now();
  }

  @Data
  @JsonIgnoreProperties(ignoreUnknown = true)
  @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
  public static class ThreadDump {
    @Min(0)
    private int count = 1;
    @Min(0)
    private long interval = 0;
  }
}
