/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.jfrog.support.common.LogsFilesMatcher;
import org.jfrog.support.common.config.SystemLogsConfiguration;
import org.jfrog.support.common.core.AbstractSpecificContentCollector;
import org.jfrog.support.common.core.collectors.DefaultFilesMatcher;
import org.jfrog.support.common.core.exceptions.BundleConfigurationException;
import org.jfrog.support.common.core.exceptions.TempDirAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogsCollector
extends AbstractSpecificContentCollector<SystemLogsConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(LogsCollector.class);
    private LogsFilesMatcher filesMatcher = new DefaultFilesMatcher();

    public LogsCollector() {
        super("logs");
    }

    protected void setFilesMatcher(LogsFilesMatcher matcher) {
        this.filesMatcher = matcher;
    }

    @Override
    protected boolean doCollect(SystemLogsConfiguration configuration, File tmpDir) {
        try {
            this.collectLogs(configuration, tmpDir);
            this.getLog().info("Collection of {} was successfully accomplished", (Object)this.getContentName());
            return true;
        }
        catch (IOException | TempDirAccessException e) {
            return this.failure(e);
        }
    }

    private void collectLogs(SystemLogsConfiguration configuration, File tmpDir) throws IOException {
        try (Stream<Path> walk = Files.walk(this.getLogsDirectory().toPath(), FileVisitOption.FOLLOW_LINKS);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> this.isCollectible((Path)f, configuration)).forEach(f -> {
                String subDir = f.getParent().toString().replace(this.getLogsDirectory().toPath().toString(), "");
                File targetLocation = new File(tmpDir.getPath() + subDir);
                try {
                    FileUtils.forceMkdir((File)targetLocation);
                }
                catch (IOException e) {
                    this.getLog().error("Failed to create a directory", (Throwable)e);
                }
                this.copyToTempDir((Path)f, targetLocation);
            });
        }
    }

    private boolean isCollectible(Path filePath, SystemLogsConfiguration configuration) {
        this.getLog().debug("Initiating collect eligibility check for file '{}'", (Object)filePath.getFileName());
        return this.filesMatcher.isMatch(filePath, configuration);
    }

    @Override
    public Logger getLog() {
        return log;
    }

    @Override
    protected void doEnsureConfiguration(SystemLogsConfiguration configuration) throws BundleConfigurationException {
        if (configuration.getDaysCount() != null) {
            this.ensureDateRange(configuration.getDaysCount());
        } else if (configuration.getStartDate() != null && configuration.getEndDate() != null) {
            this.ensureDateRange(configuration.getStartDate(), configuration.getEndDate());
        } else {
            throw new BundleConfigurationException("SystemLogsConfiguration is incomplete, either DaysCount or StartDate+EndDate must be specified");
        }
    }

    private void ensureDateRange(Date startDate, Date endDate) throws BundleConfigurationException {
        if (startDate == null || endDate == null) {
            throw new BundleConfigurationException("Date range is illegal, startDate/endDate cannot be empty");
        }
        if (startDate.getTime() > endDate.getTime()) {
            throw new BundleConfigurationException("Date range is illegal, startDate cannot be greater than endDate");
        }
    }

    private void ensureDateRange(Integer daysCount) throws BundleConfigurationException {
        if (daysCount == null) {
            throw new BundleConfigurationException("Date range is illegal, daysCount cannot be empty");
        }
        if (daysCount <= 0) {
            throw new BundleConfigurationException("Date range is illegal, daysCount cannot be negative number or zero");
        }
    }

    protected abstract File getLogsDirectory();
}

