/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jfrog.support.common.config.ConfigFilesConfiguration;
import org.jfrog.support.common.core.AbstractSpecificContentCollector;
import org.jfrog.support.common.core.exceptions.BundleConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigFilesCollector
extends AbstractSpecificContentCollector<ConfigFilesConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ConfigFilesCollector.class);

    public ConfigFilesCollector() {
        super("conf");
    }

    protected abstract List<File> getConfigFiles();

    protected abstract String[] getScrubStrings();

    @Override
    protected boolean doCollect(ConfigFilesConfiguration configuration, File tmpDir) {
        List<File> configFiles = this.getConfigFiles();
        if (configFiles != null && configFiles.size() > 0) {
            try {
                configFiles.stream().filter(f -> Files.exists(f.toPath(), new LinkOption[0])).filter(f -> Files.isRegularFile(f.toPath(), new LinkOption[0])).forEach(f -> {
                    if (configuration.isHideUserDetails()) {
                        this.scrubUserDataToTempDir(f.toPath(), tmpDir);
                    } else {
                        this.copyToTempDir(f.toPath(), tmpDir);
                    }
                });
                this.getLog().info("Collection of " + this.getContentName() + " was successfully accomplished");
                return true;
            }
            catch (Exception e) {
                return this.failure(e);
            }
        }
        this.getLog().debug("No items to work on");
        return false;
    }

    @Override
    public Logger getLog() {
        return log;
    }

    @Override
    protected void doEnsureConfiguration(ConfigFilesConfiguration configuration) throws BundleConfigurationException {
    }

    private void scrubUserDataToTempDir(Path file, File tmpDir) {
        String[] stringToScrub = this.getScrubStrings();
        File outputFile = new File(tmpDir.getPath() + File.separator + file.getFileName());
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));){
            List<String> lines = Files.readAllLines(file);
            for (String line : lines) {
                boolean writeLine = true;
                for (String password : stringToScrub) {
                    if (!line.contains(password)) continue;
                    writeLine = false;
                }
                if (!writeLine) continue;
                bw.write(line);
                bw.newLine();
            }
        }
        catch (IOException e) {
            log.error("Failed to scrub support bundle data, cause: {}", (Object)e.getMessage());
            log.debug("Failed to scrub support bundle data", (Throwable)e);
        }
    }
}

