/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.jfrog.support.common.CollectConfiguration;
import org.jfrog.support.common.core.AbstractContentCollector;
import org.jfrog.support.common.core.exceptions.TempDirAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpecificContentCollector<T extends CollectConfiguration>
extends AbstractContentCollector<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSpecificContentCollector.class);

    protected AbstractSpecificContentCollector(String contentName) {
        super(contentName);
    }

    @Override
    public Logger getLog() {
        return log;
    }

    protected void copyToTempDir(Path file, File tmpDir) {
        log.debug("Initiating copy of file '{}'", (Object)file.getFileName());
        try {
            Files.copy(file, Paths.get(tmpDir.getPath() + File.separator + file.getFileName(), new String[0]), StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            String message = e instanceof FileAlreadyExistsException ? "a file with that name already exists there" : e.getMessage();
            throw new TempDirAccessException("Cannot copy file '" + file.getFileName() + "' to '" + tmpDir.getPath() + "' because: " + message, e);
        }
    }

    protected boolean failure(Exception e) {
        this.getLog().warn("Collecting content has failed - '" + e.getMessage() + "'");
        this.getLog().debug("Cause: {}", (Throwable)e);
        this.getLog().info("Collection of " + this.getContentName() + " was not properly accomplished, see logs for more details");
        return false;
    }
}

