/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.utils;

import com.google.common.base.Strings;

import java.util.stream.IntStream;

/**
 * @author Michael Pasternak
 */
public class StringBuilderWrapper implements java.io.Serializable, CharSequence{
    public static final String NEW_LINE = getLineSeparator();

    private static String getLineSeparator() {
        return System.getProperty("line.separator") != null ?
                System.getProperty("line.separator") : "\n";
    }

    private final StringBuilder sb;

    public StringBuilderWrapper() {
        sb = new StringBuilder();
    }

    public StringBuilderWrapper(String string) {
        sb = new StringBuilder(string);
    }

    public StringBuilderWrapper(CharSequence charSequence) {
        sb = new StringBuilder(charSequence);
    }

    /**
     * @param content
     */
    public StringBuilderWrapper append(String content) {
        if (!Strings.isNullOrEmpty(content)) {
            sb.append(content);
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
        }
        return this;
    }

    /**
     * @param object
     */
    public void append(Object object) {
        if (object != null) {
            sb.append(object);
            sb.append(NEW_LINE);
        }
    }

    /**
     * @param title
     * @param content
     */
    public void append(Object title, Object content) {
        if (title != null) {
            sb.append(title);
            sb.append(": ");
            sb.append(content);
            sb.append(NEW_LINE);
        }
    }

    public void newLine() {
        sb.append(NEW_LINE);
    }

    @Override
    public int length() {
        return sb.length();
    }

    @Override
    public char charAt(int index) {
        return sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return sb.subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return sb.chars();
    }

    @Override
    public IntStream codePoints() {
        return sb.codePoints();
    }

    @Override
    public String toString() {
        return sb.toString();
    }
}
