/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.core.collectors.system.info;

/**
 * The main interface for the information groups of properties
 *
 * @author Noam Tenne
 */
public interface PropInfoGroup {

    /**
     * Returns all the info objects from the current group
     * @param isSupportBundles indicate whether we are in support bundle flow
     * @return InfoObject[] - Collection of info objects from current group
     */
    InfoObject[] getInfo(boolean isSupportBundles);
}